/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.interceptors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.rave.portal.service.PortalPreferenceService;
import org.apache.rave.service.StaticContentFetcherService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.ModelMap;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class CommonModelHandlerInterceptor
extends HandlerInterceptorAdapter {
    private final PortalPreferenceService preferenceService;
    private final StaticContentFetcherService staticContentFetcherService;

    @Autowired
    public CommonModelHandlerInterceptor(PortalPreferenceService preferenceService, StaticContentFetcherService staticContentFetcherService) {
        this.preferenceService = preferenceService;
        this.staticContentFetcherService = staticContentFetcherService;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (modelAndView != null) {
            ModelMap map = modelAndView.getModelMap();
            map.addAttribute("portalSettings", (Object)this.preferenceService.getPreferencesAsMap());
            map.addAttribute("staticContentCache", (Object)this.staticContentFetcherService);
        }
        super.postHandle(request, response, handler, modelAndView);
    }
}

