/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.model;

import java.util.Map;
import org.apache.rave.model.PortalPreference;
import org.apache.rave.portal.model.impl.PortalPreferenceImpl;

public class PortalPreferenceForm {
    public static final String DEFAULT_PAGE_SIZE = "10";
    public static final String DEFAULT_TITLE_SUFFIX = "";
    public static final String DEFAULT_JAVASCRIPT_DEBUG_MODE = "1";
    public static final String DEFAULT_WIDGET_HEIGHT = "250";
    public static final String DEFAULT_INITIAL_WIDGET_STATUS = "PREVIEW";
    public static final String DEFAULT_EXTERNAL_MARKETPLACE_URL = "";
    public static final String DEFAULT_SHOW_STACK_TRACE = "0";
    private Map<String, PortalPreference> preferenceMap;

    public PortalPreferenceForm(Map<String, PortalPreference> preferenceMap) {
        this.preferenceMap = preferenceMap;
        this.populateMissingPreferences();
    }

    private void populateMissingPreferences() {
        if (this.getPageSize() == null) {
            this.preferenceMap.put("pageSize", (PortalPreference)new PortalPreferenceImpl("pageSize", DEFAULT_PAGE_SIZE));
        }
        if (this.getTitleSuffix() == null) {
            this.preferenceMap.put("titleSuffix", (PortalPreference)new PortalPreferenceImpl("titleSuffix", ""));
        }
        if (this.getJavaScriptDebugMode() == null) {
            this.preferenceMap.put("javaScriptDebugMode", (PortalPreference)new PortalPreferenceImpl("javaScriptDebugMode", DEFAULT_JAVASCRIPT_DEBUG_MODE));
        }
        if (this.getInitialWidgetStatus() == null) {
            this.preferenceMap.put("initialWidgetStatus", (PortalPreference)new PortalPreferenceImpl("initialWidgetStatus", DEFAULT_INITIAL_WIDGET_STATUS));
        }
        if (this.getExternalMarketplaceUrl() == null) {
            this.preferenceMap.put("externalMarketplaceUrl", (PortalPreference)new PortalPreferenceImpl("externalMarketplaceUrl", ""));
        }
        if (this.getDefaultWidgetHeight() == null) {
            this.preferenceMap.put("defaultWidgetHeight", (PortalPreference)new PortalPreferenceImpl("defaultWidgetHeight", DEFAULT_WIDGET_HEIGHT));
        }
        if (this.getShowStackTrace() == null) {
            this.preferenceMap.put("showStackTrace", (PortalPreference)new PortalPreferenceImpl("showStackTrace", DEFAULT_SHOW_STACK_TRACE));
        }
    }

    public PortalPreference getExternalMarketplaceUrl() {
        return this.preferenceMap.get("externalMarketplaceUrl");
    }

    public void setExternalMarketplaceUrl(PortalPreference externalMarketplaceUrl) {
        this.preferenceMap.put("externalMarketplaceUrl", externalMarketplaceUrl);
    }

    public PortalPreference getInitialWidgetStatus() {
        return this.preferenceMap.get("initialWidgetStatus");
    }

    public PortalPreference getPageSize() {
        return this.preferenceMap.get("pageSize");
    }

    public void setPageSize(PortalPreference pageSize) {
        this.preferenceMap.put("pageSize", pageSize);
    }

    public PortalPreference getDefaultWidgetHeight() {
        return this.preferenceMap.get("defaultWidgetHeight");
    }

    public void setDefaultWidgetHeight(PortalPreference widgetHeight) {
        this.preferenceMap.put("defaultWidgetHeight", widgetHeight);
    }

    public PortalPreference getShowStackTrace() {
        return this.preferenceMap.get("showStackTrace");
    }

    public void setShowStackTrace(PortalPreference showStackTrace) {
        this.preferenceMap.put("showStackTrace", showStackTrace);
    }

    public PortalPreference getTitleSuffix() {
        return this.preferenceMap.get("titleSuffix");
    }

    public void setTitleSuffix(PortalPreference titleSuffix) {
        this.preferenceMap.put("titleSuffix", titleSuffix);
    }

    public PortalPreference getJavaScriptDebugMode() {
        return this.preferenceMap.get("javaScriptDebugMode");
    }

    public void setJavaScriptDebugMode(PortalPreference javaScriptDebugMode) {
        this.preferenceMap.put("javaScriptDebugMode", javaScriptDebugMode);
    }

    public Map<String, PortalPreference> getPreferenceMap() {
        return this.preferenceMap;
    }

    public void setPreferenceMap(Map<String, PortalPreference> preferenceMap) {
        this.preferenceMap = preferenceMap;
    }

    public void setInitialWidgetStatus(PortalPreference initialWidgetStatus) {
        this.preferenceMap.put("initialWidgetStatus", initialWidgetStatus);
    }
}

