/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.security;

import java.util.Collection;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rave.model.User;
import org.apache.rave.portal.model.impl.UserImpl;
import org.apache.rave.portal.service.NewAccountService;
import org.apache.rave.portal.service.UserService;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

public class LdapUserDetailsContextMapper
implements UserDetailsContextMapper {
    private final UserService userService;
    private final NewAccountService newAccountService;
    private final String mailAttributeName;
    private final String displayNameAttributeName;
    private final String pageLayoutCode;

    public LdapUserDetailsContextMapper(UserService userService, NewAccountService newAccountService, String mailAttributeName, String displayNameAttributeName, String pageLayoutCode) {
        this.userService = userService;
        this.newAccountService = newAccountService;
        this.mailAttributeName = mailAttributeName;
        this.displayNameAttributeName = displayNameAttributeName;
        this.pageLayoutCode = pageLayoutCode;
    }

    public UserDetails mapUserFromContext(DirContextOperations ctx, String username, Collection<? extends GrantedAuthority> authorities) {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException("Empty username from LDAP");
        }
        User byUsername = this.userService.getUserByUsername(username);
        if (byUsername == null) {
            this.createRaveUserFromLdapInfo(ctx, username);
            byUsername = this.userService.getUserByUsername(username);
        }
        return byUsername;
    }

    private void createRaveUserFromLdapInfo(DirContextOperations ctx, String username) {
        UserImpl newUser = new UserImpl();
        newUser.setUsername(username);
        if (!ctx.attributeExists(this.mailAttributeName) || StringUtils.isBlank((CharSequence)ctx.getStringAttribute(this.mailAttributeName))) {
            throw new RuntimeException("Missing LDAP attribute for email for user " + username);
        }
        newUser.setEmail(ctx.getStringAttribute(this.mailAttributeName));
        if (ctx.attributeExists(this.displayNameAttributeName)) {
            newUser.setDisplayName(ctx.getStringAttribute(this.displayNameAttributeName));
        }
        newUser.setPassword(RandomStringUtils.random((int)16));
        newUser.setDefaultPageLayoutCode(this.pageLayoutCode);
        try {
            this.newAccountService.createNewAccount((User)newUser);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not bind LDAP username '{" + username + "}' to a user", e);
        }
    }

    public void mapUserToContext(UserDetails user, DirContextAdapter ctx) {
    }
}

