/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.tag;

import javax.servlet.ServletRequest;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.rave.portal.web.renderer.ScriptLocation;

public class RegisterInitializationScriptTag
extends BodyTagSupport {
    private ScriptLocation location;

    public void setLocation(ScriptLocation location) {
        this.location = location;
    }

    public int doAfterBody() {
        this.addScriptToRequestVariable(this.getBodyContent().getString());
        return 0;
    }

    private void addScriptToRequestVariable(String script) {
        String requestAttributeName = null;
        if (this.location.equals((Object)ScriptLocation.BEFORE_RAVE)) {
            requestAttributeName = "beforeRaveInitScript";
        } else if (this.location.equals((Object)ScriptLocation.AFTER_RAVE)) {
            requestAttributeName = "afterRaveInitScript";
        } else {
            throw new IllegalArgumentException("invalid ScriptLocation " + this.location);
        }
        this.updateRequestAttribute(requestAttributeName, script);
    }

    private void updateRequestAttribute(String requestAttributeName, String script) {
        ServletRequest request = this.pageContext.getRequest();
        StringBuilder attr = (StringBuilder)request.getAttribute(requestAttributeName);
        if (attr == null) {
            attr = new StringBuilder(script);
        } else {
            attr.append(script);
        }
        request.setAttribute(requestAttributeName, (Object)attr);
    }
}

