/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.tag;

import java.util.List;
import javax.servlet.jsp.JspException;
import org.apache.rave.portal.web.renderer.ScriptLocation;
import org.apache.rave.portal.web.renderer.ScriptManager;
import org.apache.rave.portal.web.tag.AbstractContextAwareSingletonBeanDependentTag;

public class ScriptTag
extends AbstractContextAwareSingletonBeanDependentTag<ScriptManager> {
    private ScriptLocation location;

    public ScriptTag() {
        super(ScriptManager.class);
    }

    public ScriptLocation getLocation() {
        return this.location;
    }

    public void setLocation(ScriptLocation location) {
        this.location = location;
    }

    public int doStartTag() throws JspException {
        int returnValue = 0;
        ScriptManager scriptManager = (ScriptManager)this.getBean();
        this.validateParams(scriptManager);
        List scripts = scriptManager.getScriptBlocks(this.location, this.getContext());
        if (scripts != null) {
            this.renderScripts(scripts);
            returnValue = 1;
        }
        this.location = null;
        return returnValue;
    }

    private void validateParams(ScriptManager scriptManager) throws JspException {
        if (this.location == null || scriptManager == null) {
            throw new JspException("Invalid configuration.  Ensure that you have correctly configured the application and provided a location to the tag");
        }
    }

    private void renderScripts(List<String> scripts) throws JspException {
        for (String script : scripts) {
            this.writeString(script);
        }
    }
}

