/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.validator;

import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.web.model.UserForm;
import org.apache.rave.portal.web.validator.NewAccountValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class ChangePasswordValidator
extends NewAccountValidator {
    private static Logger log = LoggerFactory.getLogger(ChangePasswordValidator.class);
    @Value(value="${portal.mail.passwordservice.valid.minutes}")
    private int minutesValid;

    @Autowired
    public ChangePasswordValidator(UserService userService) {
        super(userService);
    }

    @Override
    public void validate(Object target, Errors errors) {
        log.debug("ChangePasswordValidator validator called");
        UserForm newUser = (UserForm)target;
        boolean validHash = this.getUserService().isValidReminderRequest(newUser.getForgotPasswordHash(), this.minutesValid);
        if (!validHash) {
            errors.rejectValue("password", "page.changepassword.expired");
            return;
        }
        this.validatePassword(errors, newUser);
        this.validateConfirmPassword(errors, newUser);
    }
}

