/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.validator;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.RegexValidator;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.rave.model.Widget;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public abstract class WidgetValidator
implements Validator {
    protected static final String FIELD_URL = "url";
    private final UrlValidator urlValidator;

    public WidgetValidator() {
        RegexValidator regex = new RegexValidator(new String[]{"http", "https", "((localhost)(:[0-9]+))"});
        this.urlValidator = new UrlValidator(regex, 0L);
    }

    public final boolean supports(Class<?> clazz) {
        return Widget.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        Widget widget = (Widget)target;
        this.validateRequiredFields(errors);
        this.validateIfWidgetAlreadyExists(widget, errors);
        this.validateUrlFields(widget, errors);
    }

    protected abstract void validateIfWidgetAlreadyExists(Widget var1, Errors var2);

    private void validateRequiredFields(Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"title", (String)"widget.title.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)FIELD_URL, (String)"widget.url.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"type", (String)"widget.type.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"description", (String)"widget.description.required");
    }

    private void validateUrlFields(Widget widget, Errors errors) {
        String titleUrl;
        String thumbnailUrl;
        String screenshotUrl;
        String url = widget.getUrl();
        if (StringUtils.isNotBlank((CharSequence)url) && !this.urlValidator.isValid(url)) {
            errors.rejectValue(FIELD_URL, "widget.url.malformed");
        }
        if (StringUtils.isNotBlank((CharSequence)(screenshotUrl = widget.getScreenshotUrl())) && !this.urlValidator.isValid(screenshotUrl)) {
            errors.rejectValue("screenshotUrl", "widget.screenshotUrl.malformed");
        }
        if (StringUtils.isNotBlank((CharSequence)(thumbnailUrl = widget.getThumbnailUrl())) && !this.urlValidator.isValid(thumbnailUrl)) {
            errors.rejectValue("thumbnailUrl", "widget.thumbnailUrl.malformed");
        }
        if (StringUtils.isNotBlank((CharSequence)(titleUrl = widget.getTitleUrl())) && !this.urlValidator.isValid(titleUrl)) {
            errors.rejectValue("titleUrl", "widget.titleUrl.malformed");
        }
    }
}

