/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.uri;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.Utf8UrlCoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriBuilder {
    private static final Pattern QUERY_PATTERN = Pattern.compile("([^&=]+)=([^&=]*)");
    private String scheme;
    private String authority;
    private String path;
    private String query;
    private String fragment;
    private final Map<String, List<String>> queryParameters;

    public UriBuilder(Uri uri) {
        this.scheme = uri.getScheme();
        this.authority = uri.getAuthority();
        this.path = uri.getPath();
        this.query = uri.getQuery();
        this.fragment = uri.getFragment();
        this.queryParameters = Maps.newLinkedHashMap(uri.getQueryParameters());
    }

    public UriBuilder() {
        this.queryParameters = Maps.newLinkedHashMap();
    }

    public static UriBuilder parse(String text) {
        return new UriBuilder(Uri.parse(text));
    }

    public Uri toUri() {
        return new Uri(this);
    }

    public String getScheme() {
        return this.scheme;
    }

    public UriBuilder setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String getAuthority() {
        return this.authority;
    }

    public UriBuilder setAuthority(String authority) {
        this.authority = authority;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public UriBuilder setPath(String path) {
        this.path = path;
        return this;
    }

    public String getQuery() {
        if (this.query == null) {
            this.query = UriBuilder.joinParameters(this.queryParameters);
        }
        return this.query;
    }

    public UriBuilder setQuery(String query) {
        this.queryParameters.clear();
        this.queryParameters.putAll(UriBuilder.splitParameters(query));
        this.query = query;
        return this;
    }

    public UriBuilder addQueryParameter(String name, String value) {
        this.query = null;
        ArrayList params = this.queryParameters.get(name);
        if (params == null) {
            params = Lists.newArrayList();
            this.queryParameters.put(name, params);
        }
        params.add(value);
        return this;
    }

    public UriBuilder addQueryParameters(Map<String, String> parameters) {
        this.query = null;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            this.addQueryParameter(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public UriBuilder putQueryParameter(String name, String ... values) {
        this.queryParameters.put(name, Lists.newArrayList((Object[])values));
        return this;
    }

    public Map<String, List<String>> getQueryParameters() {
        return this.queryParameters;
    }

    public List<String> getQueryParameters(String name) {
        return this.queryParameters.get(name);
    }

    public String getQueryParameter(String name) {
        Collection values = this.queryParameters.get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.iterator().next();
    }

    public String getFragment() {
        return this.fragment;
    }

    public UriBuilder setFragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    static String joinParameters(Map<String, List<String>> query) {
        if (query.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        boolean firstDone = false;
        for (Map.Entry<String, List<String>> entry : query.entrySet()) {
            String name = Utf8UrlCoder.encode(entry.getKey());
            for (String value : entry.getValue()) {
                if (firstDone) {
                    buf.append('&');
                }
                firstDone = true;
                buf.append(name).append('=').append(Utf8UrlCoder.encode(value));
            }
        }
        return buf.toString();
    }

    static Map<String, List<String>> splitParameters(String query) {
        if (query == null) {
            return Collections.emptyMap();
        }
        HashMap params = Maps.newHashMap();
        Matcher paramMatcher = QUERY_PATTERN.matcher(query);
        while (paramMatcher.find()) {
            String name = Utf8UrlCoder.decode(paramMatcher.group(1));
            String value = Utf8UrlCoder.decode(paramMatcher.group(2));
            List values = (List)params.get(name);
            if (values == null) {
                values = Lists.newArrayList();
                params.put(name, values);
            }
            values.add(value);
        }
        return Collections.unmodifiableMap(params);
    }

    public String toString() {
        return this.toUri().toString();
    }

    public int hashCode() {
        return this.toUri().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UriBuilder)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

