/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class ResourceLoader {
    public static InputStream open(String path) throws IOException {
        if (path.startsWith("res://")) {
            return ResourceLoader.openResource(path.substring(6));
        }
        File file = new File(path);
        return new FileInputStream(file);
    }

    public static InputStream openResource(String resource) throws IOException {
        ClassLoader cl = ResourceLoader.class.getClassLoader();
        InputStream is = cl.getResourceAsStream(resource.trim());
        if (is == null) {
            throw new FileNotFoundException("Can not locate resource: " + resource);
        }
        return is;
    }

    public static String getContent(String resource) throws IOException {
        return IOUtils.toString((InputStream)ResourceLoader.openResource(resource), (String)"UTF-8");
    }

    public static String getContent(File file) throws IOException {
        return IOUtils.toString((InputStream)new FileInputStream(file), (String)"UTF-8");
    }
}

