/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.shindig.common.crypto.Crypto;
import org.apache.shindig.common.util.StringEncoding;
import org.junit.Assert;

public class StringEncodingTest {
    public static Test suite() {
        return new JUnit4TestAdapter(StringEncodingTest.class);
    }

    @org.junit.Test
    public void testBase32() throws Exception {
        StringEncoding encoder = new StringEncoding("0123456789abcdefghijklmnopqrstuv".toCharArray());
        this.testEncoding(encoder, new byte[]{0}, "00");
        this.testEncoding(encoder, new byte[]{0, 0}, "0000");
        this.testEncoding(encoder, new byte[]{10, 0}, "1800");
        this.testRoundTrip(encoder, Crypto.getRandomBytes((int)1));
        this.testRoundTrip(encoder, Crypto.getRandomBytes((int)2));
        this.testRoundTrip(encoder, Crypto.getRandomBytes((int)3));
        this.testRoundTrip(encoder, Crypto.getRandomBytes((int)20));
        this.testRoundTrip(encoder, Crypto.getRandomBytes((int)30));
    }

    private void testRoundTrip(StringEncoding encoder, byte[] bytes) {
        String encoded = encoder.encode(bytes);
        byte[] decoded = encoder.decode(encoded);
        Assert.assertArrayEquals((byte[])bytes, (byte[])decoded);
    }

    private void testEncoding(StringEncoding encoder, byte[] b, String s) {
        String encoded = encoder.encode(b);
        Assert.assertEquals((Object)s, (Object)encoded);
        byte[] decoded = encoder.decode(encoded);
        Assert.assertArrayEquals((byte[])b, (byte[])decoded);
    }
}

