/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.auth.AuthenticationServletFilter;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.servlet.HttpServletResponseRecorder;
import org.junit.Before;
import org.junit.Test;

public class AuthenticationServletFilterTest
extends EasyMockTestCase {
    private static final String TEST_AUTH_HEADER = "Test Authentication Header";
    private AuthenticationServletFilter filter;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private HttpServletResponseRecorder recorder;
    private FilterChain chain;
    private AuthenticationHandler nullStHandler;

    @Before
    public void setup() {
        this.request = this.mock(HttpServletRequest.class);
        this.response = this.mock(HttpServletResponse.class);
        this.recorder = new HttpServletResponseRecorder(this.response);
        this.chain = this.mock(FilterChain.class);
        this.filter = new AuthenticationServletFilter();
        this.nullStHandler = new NullSecurityTokenAuthenticationHandler();
    }

    @Test(expected=ServletException.class)
    public void testDoFilter_BadArgs() throws Exception {
        this.filter.doFilter(null, null, null);
    }

    @Test
    public void testNullSecurityToken() throws Exception {
        this.filter.setAuthenticationHandlers((List)ImmutableList.of((Object)this.nullStHandler));
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.recorder, this.chain);
        AuthenticationServletFilterTest.assertEquals((Object)TEST_AUTH_HEADER, (Object)this.recorder.getHeader("WWW-Authenticate"));
    }

    private static class NullSecurityTokenAuthenticationHandler
    implements AuthenticationHandler {
        private NullSecurityTokenAuthenticationHandler() {
        }

        public String getName() {
            return "TestAuth";
        }

        public SecurityToken getSecurityTokenFromRequest(HttpServletRequest request) throws AuthenticationHandler.InvalidAuthenticationException {
            return null;
        }

        public String getWWWAuthenticateHeader(String realm) {
            return AuthenticationServletFilterTest.TEST_AUTH_HEADER;
        }
    }
}

