/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.shindig.auth.BlobCrypterSecurityTokenCodec;
import org.apache.shindig.auth.DefaultSecurityTokenCodec;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.config.BasicContainerConfig;
import org.apache.shindig.config.ContainerConfig;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSecurityTokenCodecTest {
    @Test
    public void testBasicDecoder() throws Exception {
        DefaultSecurityTokenCodec codec = new DefaultSecurityTokenCodec((ContainerConfig)new FakeContainerConfig("insecure"));
        Long expires = System.currentTimeMillis() / 1000L + 500L;
        String token = "o:v:app:domain:appurl:12345:container:" + Long.toString(expires, 10);
        Map<String, String> parameters = Collections.singletonMap("token", token);
        SecurityToken st = codec.createToken(parameters);
        Assert.assertEquals((Object)"o", (Object)st.getOwnerId());
        Assert.assertEquals((Object)"v", (Object)st.getViewerId());
        Assert.assertEquals((Object)"appurl", (Object)st.getAppUrl());
        Assert.assertEquals((Object)"container", (Object)st.getContainer());
        Assert.assertEquals((Object)expires, (Object)st.getExpiresAt());
    }

    @Test
    public void testInvalidDecoder() throws Exception {
        try {
            new DefaultSecurityTokenCodec((ContainerConfig)new FakeContainerConfig("garbage"));
            Assert.fail((String)"Should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((String)("exception should contain garbage: " + e), (boolean)e.getMessage().contains("garbage"));
        }
    }

    @Test
    public void testNullDecoder() throws Exception {
        try {
            new DefaultSecurityTokenCodec((ContainerConfig)new FakeContainerConfig(null));
            Assert.fail((String)"Should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((String)("exception should contain null: " + e), (boolean)e.getMessage().contains("null"));
        }
    }

    @Test
    public void testRealDecoder() throws Exception {
        DefaultSecurityTokenCodec securityTokenCodec = new DefaultSecurityTokenCodec((ContainerConfig)new FakeContainerConfig("secure"));
        Assert.assertTrue((boolean)(securityTokenCodec.getCodec() instanceof BlobCrypterSecurityTokenCodec));
    }

    private static class FakeContainerConfig
    extends BasicContainerConfig {
        private final String tokenType;

        public FakeContainerConfig(String tokenType) {
            this.tokenType = tokenType;
        }

        public Object getProperty(String container, String parameter) {
            if ("gadgets.securityTokenType".equals(parameter)) {
                if ("default".equals(container)) {
                    return this.tokenType;
                }
            } else if ("gadgets.securityTokenKey".equals(parameter)) {
                return "container key file: " + container;
            }
            return null;
        }

        public Collection<String> getContainers() {
            return Lists.newArrayList((Object[])new String[]{"somecontainer"});
        }
    }
}

