/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common;

import org.apache.shindig.common.JsonSerializer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;

public final class JsonAssert {
    private JsonAssert() {
    }

    public static void assertJsonArrayEquals(JSONArray expected, JSONArray actual) throws Exception {
        JsonAssert.assertJsonArrayEquals(null, expected, actual);
    }

    public static void assertJsonArrayEquals(String message, JSONArray expected, JSONArray actual) throws Exception {
        if (expected.length() != actual.length()) {
            Assert.assertEquals((String)"Arrays are not of equal length", (Object)expected.toString(), (Object)actual.toString());
        }
        for (int i = 0; i < expected.length(); ++i) {
            Object expectedValue = expected.opt(i);
            Object actualValue = actual.opt(i);
            Assert.assertSame((String)(expected.toString() + " != " + actual.toString()), expectedValue.getClass(), actualValue.getClass());
            if (expectedValue instanceof JSONObject) {
                JsonAssert.assertJsonObjectEquals(message, (JSONObject)expectedValue, (JSONObject)actualValue);
                continue;
            }
            if (expectedValue instanceof JSONArray) {
                JsonAssert.assertJsonArrayEquals(message, (JSONArray)expectedValue, (JSONArray)actualValue);
                continue;
            }
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        }
    }

    public static void assertJsonObjectEquals(JSONObject expected, JSONObject actual) throws Exception {
        JsonAssert.assertJsonObjectEquals(null, expected, actual);
    }

    public static void assertJsonObjectEquals(String message, JSONObject expected, JSONObject actual) throws Exception {
        if (expected.length() != actual.length()) {
            Assert.assertEquals((String)"Objects are not of equal size", (Object)expected.toString(2), (Object)actual.toString(2));
        }
        if (JSONObject.getNames((JSONObject)expected) == null && JSONObject.getNames((JSONObject)actual) == null) {
            return;
        }
        for (String name : JSONObject.getNames((JSONObject)expected)) {
            Object expectedValue = expected.opt(name);
            Object actualValue = actual.opt(name);
            if (expectedValue != null) {
                Assert.assertNotNull((String)(expected.toString() + " != " + actual.toString()), (Object)actualValue);
            }
            Assert.assertSame((String)(expected.toString() + " != " + actual.toString()), expectedValue.getClass(), actualValue.getClass());
            if (expectedValue instanceof JSONObject) {
                JsonAssert.assertJsonObjectEquals(message, (JSONObject)expectedValue, (JSONObject)actualValue);
                continue;
            }
            if (expectedValue instanceof JSONArray) {
                JsonAssert.assertJsonArrayEquals(message, (JSONArray)expectedValue, (JSONArray)actualValue);
                continue;
            }
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        }
    }

    public static void assertJsonEquals(String expected, String actual) throws Exception {
        JsonAssert.assertJsonEquals(null, expected, actual);
    }

    public static void assertJsonEquals(String message, String expected, String actual) throws Exception {
        switch (expected.charAt(0)) {
            case '{': {
                JsonAssert.assertJsonObjectEquals(message, new JSONObject(expected), new JSONObject(actual));
                break;
            }
            case '[': {
                JsonAssert.assertJsonArrayEquals(message, new JSONArray(expected), new JSONArray(actual));
                break;
            }
            default: {
                Assert.assertEquals((Object)expected, (Object)actual);
            }
        }
    }

    public static void assertObjectEquals(Object expected, Object actual) throws Exception {
        JsonAssert.assertObjectEquals(null, expected, actual);
    }

    public static void assertObjectEquals(String message, Object expected, Object actual) throws Exception {
        if (!(expected instanceof String)) {
            expected = JsonSerializer.serialize((Object)expected);
        }
        if (!(actual instanceof String)) {
            actual = JsonSerializer.serialize((Object)actual);
        }
        JsonAssert.assertJsonEquals(message, (String)expected, (String)actual);
    }
}

