/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.cache;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.LruCache;
import org.apache.shindig.common.cache.LruCacheProvider;
import org.junit.Assert;
import org.junit.Test;

public class LruCacheProviderTest {
    private LruCache<Object, Object> getCache(CacheProvider provider, String name) {
        Cache base = provider.createCache(name);
        return (LruCache)base;
    }

    @Test
    public void defaultCapacityForNamedCache() throws Exception {
        LruCacheProvider provider = new LruCacheProvider(10);
        Assert.assertEquals((long)10L, (long)this.getCache((CacheProvider)provider, (String)"foo").capacity);
    }

    LruCacheProvider createProvider(final String name, final String capacity, int defaultCapacity) {
        AbstractModule module = new AbstractModule(){

            public void configure() {
                this.binder().bindConstant().annotatedWith((Annotation)Names.named((String)("shindig.cache.lru." + name + ".capacity"))).to(capacity);
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        return new LruCacheProvider(injector, defaultCapacity);
    }

    @Test
    public void configuredMultipleCalls() throws Exception {
        LruCacheProvider provider = this.createProvider("foo", "100", 10);
        Assert.assertSame(this.getCache((CacheProvider)provider, "foo"), this.getCache((CacheProvider)provider, "foo"));
    }

    @Test
    public void configuredCapacity() throws Exception {
        LruCacheProvider provider = this.createProvider("foo", "100", 10);
        Assert.assertEquals((long)100L, (long)this.getCache((CacheProvider)provider, (String)"foo").capacity);
    }

    @Test
    public void missingConfiguredCapacity() throws Exception {
        LruCacheProvider provider = this.createProvider("foo", "100", 10);
        Assert.assertEquals((long)10L, (long)this.getCache((CacheProvider)provider, (String)"bar").capacity);
    }

    @Test
    public void malformedConfiguredCapacity() throws Exception {
        LruCacheProvider provider = this.createProvider("foo", "adfdf", 10);
        Assert.assertEquals((long)10L, (long)this.getCache((CacheProvider)provider, (String)"foo").capacity);
    }
}

