/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.shindig.common.util.DateUtil;

public class HttpServletResponseRecorder
extends HttpServletResponseWrapper {
    protected final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private PrintWriter writer;
    private final Map<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private int httpStatusCode = 200;
    private String encoding = Charset.defaultCharset().name();

    public HttpServletResponseRecorder(HttpServletResponse response) {
        super(response);
    }

    public String getResponseAsString() {
        try {
            this.getWriter().close();
            return new String(this.baos.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            return null;
        }
    }

    public byte[] getResponseAsBytes() {
        return this.baos.toByteArray();
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.baos, this.encoding));
        }
        return this.writer;
    }

    public ServletOutputStream getOutputStream() {
        return new ServletOutputStream(){

            public void write(int b) {
                HttpServletResponseRecorder.this.baos.write(b);
            }
        };
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setHeader(String name, String value) {
        this.addHeader(name, value);
    }

    public void addDateHeader(String name, long date) {
        this.headers.put(name, DateUtil.formatRfc1123Date((long)date));
    }

    public void setDateHeader(String name, long date) {
        this.addDateHeader(name, date);
    }

    public void setStatus(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public void sendError(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public void sendRedirect(String location) {
        this.setStatus(302);
        this.setHeader("Location", location);
    }

    public void setStatus(int httpStatusCode, String msg) {
        try {
            this.getWriter().write(msg);
            this.httpStatusCode = httpStatusCode;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendError(int httpStatusCode, String msg) {
        try {
            this.getWriter().write(msg);
            this.httpStatusCode = httpStatusCode;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setContentType(String type) {
        this.headers.put("Content-Type", type);
    }

    public String getContentType() {
        return this.headers.get("Content-Type");
    }

    public void setCharacterEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }
}

