/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.testing;

import java.util.EnumSet;
import java.util.Map;
import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.auth.AuthenticationMode;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenException;

public class FakeGadgetToken
extends AbstractSecurityToken {
    private String authMode = AuthenticationMode.SECURITY_TOKEN_URL_PARAMETER.name();
    private String updated;

    public String getAuthenticationMode() {
        return this.authMode;
    }

    public boolean isAnonymous() {
        return false;
    }

    public FakeGadgetToken() {
    }

    public FakeGadgetToken(Map<String, String> paramMap) {
        this(paramMap.get("appId"), paramMap.get("appUrl"), paramMap.get("domain"), paramMap.get("ownerId"), paramMap.get("trustedJson"), paramMap.get("viewerId"), paramMap.get("module"));
    }

    public FakeGadgetToken(String appId, String appUrl, String domain, String ownerId, String trustedJson, String viewerId, String moduleId) {
        this.setAppId(appId);
        this.setAppUrl(appUrl);
        this.setDomain(domain);
        this.setOwnerId(ownerId);
        this.setTrustedJson(trustedJson);
        this.setViewerId(viewerId);
        if (moduleId != null) {
            this.setModuleId(Long.parseLong(moduleId));
        }
    }

    public FakeGadgetToken setAuthenticationMode(String authMode) {
        this.authMode = authMode;
        return this;
    }

    public FakeGadgetToken setUpdatedToken(String updated) {
        this.updated = updated;
        return this;
    }

    public String getUpdatedToken() {
        return this.updated;
    }

    protected EnumSet<AbstractSecurityToken.Keys> getMapKeys() {
        return EnumSet.noneOf(AbstractSecurityToken.Keys.class);
    }

    public FakeGadgetToken setAppUrl(String appUrl) {
        return (FakeGadgetToken)super.setAppUrl(appUrl);
    }

    public FakeGadgetToken setOwnerId(String ownerId) {
        return (FakeGadgetToken)super.setOwnerId(ownerId);
    }

    public FakeGadgetToken setViewerId(String viewerId) {
        return (FakeGadgetToken)super.setViewerId(viewerId);
    }

    public FakeGadgetToken setAppId(String appId) {
        return (FakeGadgetToken)super.setAppId(appId);
    }

    public FakeGadgetToken setDomain(String domain) {
        return (FakeGadgetToken)super.setDomain(domain);
    }

    public FakeGadgetToken setContainer(String container) {
        return (FakeGadgetToken)super.setContainer(container);
    }

    public FakeGadgetToken setModuleId(long moduleId) {
        return (FakeGadgetToken)super.setModuleId(moduleId);
    }

    public FakeGadgetToken setExpiresAt(Long expiresAt) {
        return (FakeGadgetToken)super.setExpiresAt(expiresAt);
    }

    public FakeGadgetToken setTrustedJson(String trustedJson) {
        return (FakeGadgetToken)super.setTrustedJson(trustedJson);
    }

    public FakeGadgetToken setActiveUrl(String activeUrl) {
        return (FakeGadgetToken)super.setActiveUrl(activeUrl);
    }

    public static class Codec
    implements SecurityTokenCodec {
        public SecurityToken createToken(Map<String, String> tokenParameters) {
            return new FakeGadgetToken(tokenParameters);
        }

        public String encodeToken(SecurityToken token) throws SecurityTokenException {
            return null;
        }

        public int getTokenTimeToLive() {
            return 0;
        }

        public int getTokenTimeToLive(String container) {
            return 0;
        }
    }
}

