/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.testing;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;

public class FakeHttpServletRequest
implements HttpServletRequest {
    protected static final String DEFAULT_HOST = "localhost";
    protected static final int DEFAULT_PORT = 80;
    private static final String COOKIE_HEADER = "Cookie";
    private static final String HOST_HEADER = "Host";
    private static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    protected String scheme = "http";
    protected String host;
    protected int port;
    protected boolean secure = false;
    protected String method = "GET";
    protected String protocol = "HTTP/1.0";
    protected String contextPath;
    protected String servletPath;
    protected String pathInfo = null;
    protected String queryString;
    protected String ip = "127.0.0.1";
    protected String contentType;
    protected Hashtable<String, String> headers = new Hashtable();
    protected Map<String, String[]> parameters = Maps.newLinkedHashMap();
    protected Set<String> postParameters = Sets.newHashSet();
    protected Map<String, Cookie> cookies = new Hashtable<String, Cookie>();
    protected Map<String, Object> attributes = Maps.newHashMap();
    protected Locale locale = Locale.US;
    protected List<Locale> locales = null;
    protected byte[] postData;
    protected String characterEncoding;
    protected boolean getReaderCalled = false;
    protected boolean getInputStreamCalled = false;
    private HttpSession session;
    static final String METHOD_POST = "POST";

    public FakeHttpServletRequest(String host, int port, String contextPath, String servletPath, String queryString) {
        this.constructor(host, port, contextPath, servletPath, queryString);
    }

    public FakeHttpServletRequest(String host, String port, String contextPath, String servletPath, String queryString) {
        this(host, Integer.parseInt(port), contextPath, servletPath, queryString);
    }

    public FakeHttpServletRequest(String contextPath, String servletPath, String queryString) {
        this(DEFAULT_HOST, -1, contextPath, servletPath, queryString);
    }

    public FakeHttpServletRequest() {
        this(DEFAULT_HOST, 80, "", null, null);
    }

    public FakeHttpServletRequest(String urlStr) throws MalformedURLException {
        String servletPath;
        String contextPath;
        URL url = new URL(urlStr);
        String path = url.getPath();
        if (path.length() <= 1) {
            contextPath = path;
            servletPath = null;
        } else {
            int secondSlash = path.indexOf(47, 1);
            if (secondSlash < 0) {
                contextPath = path;
                servletPath = null;
            } else {
                contextPath = path.substring(0, secondSlash);
                servletPath = path.substring(secondSlash);
            }
        }
        this.scheme = url.getProtocol();
        if (this.scheme.equalsIgnoreCase("https")) {
            this.secure = true;
        }
        int port = url.getPort();
        this.constructor(url.getHost(), port, contextPath, servletPath, url.getQuery());
    }

    public FakeHttpServletRequest setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public FakeHttpServletRequest setLocales(List<Locale> locales) {
        this.locales = locales;
        return this;
    }

    public FakeHttpServletRequest setProtocol(String prot) {
        this.protocol = prot;
        return this;
    }

    public FakeHttpServletRequest setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public FakeHttpServletRequest setHeader(String name, String value) {
        if (name.equals(COOKIE_HEADER)) {
            String[] pairs;
            for (String pair : pairs = FakeHttpServletRequest.splitAndTrim(value, ";")) {
                int equalsPos = pair.indexOf(61);
                if (equalsPos == -1) continue;
                String cookieName = pair.substring(0, equalsPos);
                String cookieValue = pair.substring(equalsPos + 1);
                this.addToCookieMap(new Cookie(cookieName, cookieValue));
            }
            this.setCookieHeader();
            return this;
        }
        this.addToHeaderMap(name, value);
        if (name.equals(HOST_HEADER)) {
            this.host = value;
        }
        return this;
    }

    private void addToHeaderMap(String name, String value) {
        this.headers.put(name.toLowerCase(), value);
    }

    public FakeHttpServletRequest setCookies(Cookie ... cookies) {
        for (Cookie cookie : cookies) {
            this.addToCookieMap(cookie);
        }
        this.setCookieHeader();
        return this;
    }

    public FakeHttpServletRequest setCookie(Cookie c) {
        this.addToCookieMap(c);
        this.setCookieHeader();
        return this;
    }

    private void addToCookieMap(Cookie c) {
        this.cookies.put(c.getName(), c);
    }

    private void setCookieHeader() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Cookie c : this.cookies.values()) {
            if (!isFirst) {
                sb.append("; ");
            }
            sb.append(c.getName());
            sb.append('=');
            sb.append(c.getValue());
            isFirst = false;
        }
        this.addToHeaderMap(COOKIE_HEADER, sb.toString());
    }

    public FakeHttpServletRequest setParameter(String name, boolean isPost, String ... values) {
        if (isPost) {
            this.postParameters.add(name);
        }
        this.parameters.put(name, values);
        this.queryString = null;
        return this;
    }

    public FakeHttpServletRequest setParameter(String name, String ... values) {
        this.setParameter(name, false, values);
        return this;
    }

    public FakeHttpServletRequest setPathInfo(String path) {
        this.pathInfo = path;
        return this;
    }

    public FakeHttpServletRequest setPostData(String postString, String encoding) throws UnsupportedEncodingException {
        this.setPostData(postString.getBytes(encoding));
        this.characterEncoding = encoding;
        return this;
    }

    public FakeHttpServletRequest setPostData(byte[] data) {
        this.postData = data;
        this.characterEncoding = null;
        this.method = METHOD_POST;
        return this;
    }

    public FakeHttpServletRequest setQueryString(String queryString) {
        this.queryString = queryString;
        this.parameters.clear();
        this.decodeQueryString(queryString, this.parameters);
        return this;
    }

    public FakeHttpServletRequest setSession(HttpSession session) {
        this.session = session;
        return this;
    }

    public FakeHttpServletRequest setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getAuthType() {
        throw new UnsupportedOperationException();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        if (this.cookies.isEmpty()) {
            return null;
        }
        return this.cookies.values().toArray(new Cookie[this.cookies.size()]);
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return format.parse(value).getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse number from header " + name + ':' + value, e);
        }
    }

    public FakeHttpServletRequest setDateHeader(String name, long value) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.setHeader(name, format.format(new Date(value)));
        return this;
    }

    public String getHeader(String name) {
        return this.headers.get(name.toLowerCase());
    }

    public Enumeration<String> getHeaderNames() {
        return this.headers.keys();
    }

    public Enumeration<?> getHeaders(String name) {
        ArrayList values = Lists.newArrayList();
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            if (!name.equalsIgnoreCase(entry.getKey())) continue;
            values.add(entry.getValue());
        }
        return Collections.enumeration(values);
    }

    public int getIntHeader(String name) {
        return Integer.parseInt(this.getHeader(name));
    }

    public String getMethod() {
        return this.method;
    }

    public FakeHttpServletRequest setMethod(String method) {
        this.method = method;
        return this;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        throw new UnsupportedOperationException();
    }

    public String getQueryString() {
        try {
            if (this.queryString == null && !this.parameters.isEmpty()) {
                boolean hasPrevious = false;
                StringBuilder queryString = new StringBuilder();
                for (Map.Entry<String, String[]> entry : this.parameters.entrySet()) {
                    String[] values;
                    if (StringUtils.isBlank((CharSequence)entry.getKey()) || this.postParameters.contains(entry.getKey())) continue;
                    if (hasPrevious) {
                        queryString.append('&');
                    }
                    if ((values = entry.getValue()).length == 0) {
                        queryString.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                    } else {
                        for (int i = 0; i < values.length; ++i) {
                            queryString.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append('=').append(URLEncoder.encode(values[i], "UTF-8"));
                            if (i >= values.length - 1) continue;
                            queryString.append('&');
                        }
                    }
                    hasPrevious = true;
                }
                this.queryString = queryString.toString();
            }
            return this.queryString;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Should always support UTF-8", e);
        }
    }

    public String getRemoteUser() {
        throw new UnsupportedOperationException();
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException();
    }

    public String getRequestURI() {
        StringBuilder buf = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.contextPath)) {
            buf.append(this.contextPath);
        }
        if (this.servletPath != null && !"".equals(this.servletPath)) {
            buf.append(this.servletPath);
        }
        if (buf.length() == 0) {
            buf.append('/');
        }
        return buf.toString();
    }

    public StringBuffer getRequestURL() {
        StringBuffer buf = this.secure ? new StringBuffer("https://") : new StringBuffer("http://");
        buf.append(this.host);
        if (this.port >= 0) {
            buf.append(':');
            buf.append(this.port);
        }
        buf.append(this.getRequestURI());
        return buf;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public FakeHttpServletRequest setServletPath(String servletPath) {
        this.servletPath = servletPath;
        return this;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        return this.session;
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException("This method is deprecated");
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<?> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        return this.postData == null ? 0 : this.postData.length;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletInputStream getInputStream() {
        if (this.getReaderCalled) {
            throw new IllegalStateException("getInputStream() called after getReader()");
        }
        this.getInputStreamCalled = true;
        final ByteArrayInputStream in = new ByteArrayInputStream(this.postData);
        return new ServletInputStream(){

            public int read() throws IOException {
                return in.read();
            }
        };
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration<?> getLocales() {
        return Collections.enumeration(this.locales);
    }

    public String getParameter(String name) {
        String[] parameters = this.getParameterValues(name);
        if (parameters == null || parameters.length < 1) {
            return null;
        }
        return parameters[0];
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public BufferedReader getReader() throws IOException {
        if (this.getInputStreamCalled) {
            throw new IllegalStateException("getReader() called after getInputStream()");
        }
        this.getReaderCalled = true;
        BufferedReader br = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(this.postData);
        InputStreamReader isr = this.characterEncoding != null ? new InputStreamReader((InputStream)bais, this.characterEncoding) : new InputStreamReader(bais);
        br = new BufferedReader(isr);
        return br;
    }

    @Deprecated
    public String getRealPath(String path) {
        throw new UnsupportedOperationException("This method is deprecated");
    }

    public String getRemoteAddr() {
        return this.ip;
    }

    public FakeHttpServletRequest setRemoteAddr(String ip) {
        this.ip = ip;
        return this;
    }

    public String getRemoteHost() {
        return DEFAULT_HOST;
    }

    public int getLocalPort() {
        return 8080;
    }

    public String getLocalAddr() {
        return "127.0.0.1";
    }

    public String getLocalName() {
        return DEFAULT_HOST;
    }

    public int getRemotePort() {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException();
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.host;
    }

    public int getServerPort() {
        return this.port < 0 ? 80 : this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void setCharacterEncoding(String env) {
        if (this.method.equals(METHOD_POST)) {
            this.characterEncoding = env;
        }
    }

    protected void constructor(String host, int port, String contextPath, String servletPath, String queryString) {
        this.setHeader(HOST_HEADER, host);
        this.port = port;
        this.contextPath = contextPath;
        this.servletPath = servletPath;
        this.queryString = queryString;
        if (queryString != null) {
            this.decodeQueryString(queryString, this.parameters);
        }
    }

    protected void decodeQueryString(String queryString, Map<String, String[]> parameters) {
        for (String param : queryString.split("&")) {
            String value;
            String name;
            int sepPos = param.indexOf(61);
            if (sepPos < 0) {
                name = param;
                value = "";
            } else {
                name = param.substring(0, sepPos);
                value = param.substring(sepPos + 1);
            }
            this.addParameter(parameters, this.decodeParameterPart(name), this.decodeParameterPart(value));
        }
    }

    private String decodeParameterPart(String str) {
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (IllegalArgumentException iae) {
            return str;
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    protected void addParameter(Map<String, String[]> parameters, String name, String value) {
        if (parameters.containsKey(name)) {
            String[] existingParamValues = parameters.get(name);
            String[] newParamValues = new String[existingParamValues.length + 1];
            System.arraycopy(existingParamValues, 0, newParamValues, 0, existingParamValues.length);
            newParamValues[newParamValues.length - 1] = value;
            parameters.put(name, newParamValues);
        } else {
            String[] paramValues = new String[]{value};
            parameters.put(name, paramValues);
        }
    }

    private static String[] splitAndTrim(String str, String delims) {
        StringTokenizer tokenizer = new StringTokenizer(str, delims);
        int n = tokenizer.countTokens();
        String[] list = new String[n];
        for (int i = 0; i < n; ++i) {
            list[i] = tokenizer.nextToken().trim();
        }
        return list;
    }
}

