/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.config;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.apache.shindig.config.BasicContainerConfigTest;
import org.apache.shindig.config.ExpressionContainerConfig;
import org.apache.shindig.expressions.Expressions;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionContainerConfigTest
extends BasicContainerConfigTest {
    private static final Map<String, Object> DEFAULT_EXPR_CONTAINER = ExpressionContainerConfigTest.makeContainer("default", "expr", "${inherited}", "inherited", "yes");
    private static final Map<String, Object> MODIFIED_DEFAULT_EXPR_CONTAINER = ExpressionContainerConfigTest.makeContainer("default", "expr", "${inherited}", "inherited", "si");

    @Override
    public void setUp() throws Exception {
        this.config = new ExpressionContainerConfig(Expressions.forTesting());
        this.config.newTransaction().addContainer(DEFAULT_EXPR_CONTAINER).commit();
    }

    @Override
    public void testGetProperties() throws Exception {
        Assert.assertEquals((Object)ImmutableSet.of((Object)"gadgets.container", (Object)"inherited", (Object)"expr"), this.config.getProperties("default").keySet());
    }

    @Test
    public void testExpressionValues() throws Exception {
        Assert.assertEquals((Object)"yes", (Object)this.config.getString("default", "expr"));
    }

    @Test
    public void testExpressionInheritance() throws Exception {
        this.config.newTransaction().addContainer(EXTRA_CONTAINER).commit();
        Assert.assertEquals((Object)"yes", (Object)this.config.getString("default", "expr"));
        Assert.assertEquals((Object)"yes", (Object)this.config.getString("extra", "expr"));
        this.config.newTransaction().addContainer(MODIFIED_EXTRA_CONTAINER).commit();
        Assert.assertEquals((Object)"no", (Object)this.config.getString("extra", "expr"));
        this.config.newTransaction().addContainer(MODIFIED_DEFAULT_EXPR_CONTAINER).commit();
        this.config.newTransaction().addContainer(EXTRA_CONTAINER).commit();
        Assert.assertEquals((Object)"si", (Object)this.config.getString("extra", "expr"));
        Assert.assertEquals((Object)"si", (Object)this.config.getString("extra", "expr"));
    }
}

