/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Map;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.protocol.BaseRequestItem;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.protocol.model.SortOrder;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BaseRequestItemTest
extends Assert {
    private static final FakeGadgetToken FAKE_TOKEN = new FakeGadgetToken();
    protected BaseRequestItem request;
    protected BeanJsonConverter converter;

    @Before
    public void setUp() throws Exception {
        FAKE_TOKEN.setAppId("12345");
        FAKE_TOKEN.setOwnerId("someowner");
        FAKE_TOKEN.setViewerId("someowner");
        this.converter = new BeanJsonConverter(Guice.createInjector((Module[])new Module[0]));
        this.request = new BaseRequestItem((Map)Maps.newHashMap(), (SecurityToken)FAKE_TOKEN, (BeanConverter)this.converter, this.converter);
    }

    @Test
    public void testParseCommaSeparatedList() throws Exception {
        this.request.setParameter("fields", (Object)"huey,dewey,louie");
        BaseRequestItemTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"huey", "dewey", "louie"}), (Object)this.request.getListParameter("fields"));
    }

    @Test
    public void testGetAppId() throws Exception {
        this.request.setParameter("appId", (Object)"100");
        BaseRequestItemTest.assertEquals((Object)"100", (Object)this.request.getAppId());
        this.request.setParameter("appId", (Object)"@app");
        BaseRequestItemTest.assertEquals((Object)FAKE_TOKEN.getAppId(), (Object)this.request.getAppId());
    }

    @Test
    public void testStartIndex() throws Exception {
        this.request.setParameter("startIndex", null);
        BaseRequestItemTest.assertEquals((long)0L, (long)this.request.getStartIndex());
        this.request.setParameter("startIndex", (Object)"5");
        BaseRequestItemTest.assertEquals((long)5L, (long)this.request.getStartIndex());
    }

    @Test
    public void testCount() throws Exception {
        this.request.setParameter("count", null);
        BaseRequestItemTest.assertEquals((long)20L, (long)this.request.getCount());
        this.request.setParameter("count", (Object)"5");
        BaseRequestItemTest.assertEquals((long)5L, (long)this.request.getCount());
    }

    @Test
    public void testSortOrder() throws Exception {
        this.request.setParameter("sortOrder", null);
        BaseRequestItemTest.assertEquals((Object)SortOrder.ascending, (Object)this.request.getSortOrder());
        this.request.setParameter("sortOrder", (Object)"descending");
        BaseRequestItemTest.assertEquals((Object)SortOrder.descending, (Object)this.request.getSortOrder());
    }

    @Test
    public void testFields() throws Exception {
        this.request.setParameter("fields", (Object)"");
        BaseRequestItemTest.assertEquals((Object)Sets.newHashSet(), (Object)this.request.getFields());
        this.request.setParameter("fields", (Object)"happy,sad,grumpy");
        BaseRequestItemTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"happy", "sad", "grumpy"}), (Object)this.request.getFields());
    }

    @Test
    public void testGetTypedParameter() throws Exception {
        this.request.setParameter("anykey", (Object)"{name: 'Bob', id: '1234'}");
        InputData input = (InputData)this.request.getTypedParameter("anykey", InputData.class);
        BaseRequestItemTest.assertEquals((Object)"Bob", (Object)input.name);
        BaseRequestItemTest.assertEquals((long)1234L, (long)input.id);
    }

    @Test(expected=ProtocolException.class)
    public void testGetTypedParameterEmpty() throws Exception {
        this.request.getTypedParameter("empty", InputData.class);
    }

    @Test
    public void testGetParameters() throws Exception {
        this.request.setParameter("anykey", (Object)"{name: 'Bob', id: '1234'}");
        Map params = this.request.getParameters();
        BaseRequestItemTest.assertEquals((long)1L, (long)params.size());
        BaseRequestItemTest.assertTrue((boolean)params.containsKey("anykey"));
        try {
            params.put("this", "is bad");
            BaseRequestItemTest.fail((String)"Params should be immutable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testGetInvalidJsonTypedParameter() throws Exception {
        this.request.setParameter("anykey", (Object)"{name: 'Bob");
        int code = 0;
        try {
            this.request.getTypedParameter("anykey", InputData.class);
        }
        catch (ProtocolException e) {
            code = e.getCode();
        }
        BaseRequestItemTest.assertEquals((long)400L, (long)code);
    }

    @Test
    public void testJSONConstructor() throws Exception {
        this.request = new BaseRequestItem(new JSONObject("{userId:john.doe,groupId:@self,fields:[huey,dewey,louie]}"), null, (SecurityToken)FAKE_TOKEN, (BeanConverter)this.converter, this.converter);
        BaseRequestItemTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"huey", "dewey", "louie"}), (Object)this.request.getListParameter("fields"));
    }

    @Test
    public void testAttributes() throws Exception {
        BaseRequestItemTest.assertNull((Object)this.request.getAttribute("undefined"));
        this.request.setAttribute("test", (Object)"value");
        BaseRequestItemTest.assertEquals((Object)"value", (Object)this.request.getAttribute("test"));
        this.request.setAttribute("test", null);
        BaseRequestItemTest.assertNull((Object)this.request.getAttribute("undefined"));
    }

    public static class InputData {
        String name;
        int id;

        public void setName(String name) {
            this.name = name;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

