/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.shindig.protocol.RestfulCollection;
import org.junit.Assert;
import org.junit.Test;

public class RestfulCollectionTest
extends Assert {
    @Test
    public void testBasicMethods() throws Exception {
        RestfulCollection collection = new RestfulCollection((List)Lists.newArrayList());
        ArrayList entryList = Lists.newArrayList((Object[])new String[]{"banana"});
        int startIndex = 5;
        int totalResults = 8675309;
        collection.setList((List)entryList);
        collection.setStartIndex(startIndex);
        collection.setTotalResults(totalResults);
        RestfulCollectionTest.assertEquals((Object)entryList, (Object)collection.getList());
        RestfulCollectionTest.assertEquals((long)startIndex, (long)collection.getStartIndex());
        RestfulCollectionTest.assertEquals((long)totalResults, (long)collection.getTotalResults());
    }

    @Test
    public void testConstructors() throws Exception {
        ArrayList entry = Lists.newArrayList((Object[])new String[]{"banana", "who"});
        RestfulCollection collection = new RestfulCollection((List)entry);
        RestfulCollectionTest.assertEquals((Object)entry, (Object)collection.getList());
        RestfulCollectionTest.assertEquals((long)0L, (long)collection.getStartIndex());
        RestfulCollectionTest.assertEquals((long)entry.size(), (long)collection.getTotalResults());
        RestfulCollectionTest.assertEquals((long)entry.size(), (long)collection.getItemsPerPage());
        int startIndex = 9;
        int totalResults = 10;
        int resultsPerPage = 1;
        collection = new RestfulCollection((List)entry, startIndex, totalResults, resultsPerPage);
        RestfulCollectionTest.assertEquals((Object)entry, (Object)collection.getList());
        RestfulCollectionTest.assertEquals((long)startIndex, (long)collection.getStartIndex());
        RestfulCollectionTest.assertEquals((long)totalResults, (long)collection.getTotalResults());
        RestfulCollectionTest.assertEquals((long)resultsPerPage, (long)collection.getItemsPerPage());
    }

    @Test
    public void testMapMethods() throws Exception {
        RestfulCollection collection = new RestfulCollection((List)Lists.newArrayList());
        ArrayList entryList = Lists.newArrayList((Object[])new String[]{"banana"});
        int startIndex = 5;
        int totalResults = 8675309;
        String anyItem = "anyvalue";
        collection.put((Object)"list", (Object)entryList);
        collection.put((Object)"startIndex", (Object)startIndex);
        collection.put((Object)"totalResults", (Object)totalResults);
        collection.put((Object)"anyItem", (Object)anyItem);
        RestfulCollectionTest.assertEquals((Object)entryList, (Object)collection.get((Object)"list"));
        RestfulCollectionTest.assertEquals((Object)startIndex, (Object)collection.get((Object)"startIndex"));
        RestfulCollectionTest.assertEquals((Object)totalResults, (Object)collection.get((Object)"totalResults"));
        RestfulCollectionTest.assertEquals((Object)anyItem, (Object)collection.get((Object)"anyItem"));
        int resultsPerPage = 1;
        ArrayList entry = Lists.newArrayList((Object[])new String[]{"banana", "who"});
        collection = new RestfulCollection((List)entry, startIndex, totalResults, resultsPerPage);
        RestfulCollectionTest.assertEquals((Object)entry, (Object)collection.get((Object)"list"));
        RestfulCollectionTest.assertEquals((Object)startIndex, (Object)collection.get((Object)"startIndex"));
        RestfulCollectionTest.assertEquals((Object)totalResults, (Object)collection.get((Object)"totalResults"));
        RestfulCollectionTest.assertEquals((Object)resultsPerPage, (Object)collection.get((Object)"itemsPerPage"));
    }
}

