/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.protocol.model.ExtendableBean;
import org.apache.shindig.protocol.model.Model;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BeanJsonConverterTest
extends Assert {
    private BeanJsonConverter beanJsonConverter;

    @Before
    public void setUp() throws Exception {
        this.beanJsonConverter = new BeanJsonConverter(Guice.createInjector((Module[])new Module[0]));
    }

    @Test
    public void testJsonToObject() throws Exception {
        String json = "{hello:'world',count:10,someStatic:'foo',testEnum:'bar',children:[{hello:'world-2',count:11},{hello:'world-3',count:12}]}";
        TestObject object = (TestObject)this.beanJsonConverter.convertToObject(json, TestObject.class);
        BeanJsonConverterTest.assertEquals((Object)"world", (Object)object.hello);
        BeanJsonConverterTest.assertEquals((long)10L, (long)object.count);
        BeanJsonConverterTest.assertEquals((Object)"world-2", (Object)object.children.get((int)0).hello);
        BeanJsonConverterTest.assertEquals((long)11L, (long)object.children.get((int)0).count);
        BeanJsonConverterTest.assertEquals((Object)"world-3", (Object)object.children.get((int)1).hello);
        BeanJsonConverterTest.assertEquals((long)12L, (long)object.children.get((int)1).count);
        BeanJsonConverterTest.assertNull((String)"Should not set static values", (Object)TestObject.staticValue);
        BeanJsonConverterTest.assertEquals((Object)((Object)TestObject.TestEnum.bar), (Object)((Object)object.testEnum));
    }

    @Test
    public void testJsonToPrimitives() throws Exception {
        String simpleJson = "{hello:'world',count:10}";
        Object object = this.beanJsonConverter.convertToObject(simpleJson, null);
        Map map = (Map)object;
        BeanJsonConverterTest.assertEquals((Object)"world", map.get("hello"));
        BeanJsonConverterTest.assertEquals((Object)10, map.get("count"));
    }

    @Test
    public void testJsonToCar() throws Exception {
        String carJson = "{engine:[{value:DIESEL},{value:TURBO}],parkingTickets:{SF:$137,NY:'$301'},passengers:[{gender:female,name:'Mum'}, {gender:male,name:'Dad'}]}";
        Model.Car car = (Model.Car)this.beanJsonConverter.convertToObject(carJson, Model.Car.class);
        ArrayList engineInfo = Lists.newArrayList((Object[])new Model.Engine[]{Model.Engine.DIESEL, Model.Engine.TURBO});
        for (int i = 0; i < car.getEngine().size(); ++i) {
            BeanJsonConverterTest.assertEquals((Object)car.getEngine().get(i).getValue(), engineInfo.get(i));
        }
        BeanJsonConverterTest.assertEquals(car.getParkingTickets(), (Object)ImmutableMap.of((Object)"SF", (Object)"$137", (Object)"NY", (Object)"$301"));
        Model.Passenger mum = car.getPassengers().get(0);
        BeanJsonConverterTest.assertEquals((Object)((Object)Model.Gender.female), (Object)((Object)mum.getGender()));
        BeanJsonConverterTest.assertEquals((Object)"Mum", (Object)mum.getName());
        Model.Passenger dad = car.getPassengers().get(1);
        BeanJsonConverterTest.assertEquals((Object)((Object)Model.Gender.male), (Object)((Object)dad.getGender()));
        BeanJsonConverterTest.assertEquals((Object)"Dad", (Object)dad.getName());
    }

    @Test
    public void testJsonToMap() throws Exception {
        String jsonActivity = "{count : 0, favoriteColor : 'yellow'}";
        Map data = (Map)this.beanJsonConverter.convertToObject(jsonActivity, new TypeLiteral<Map<String, Object>>(){}.getType());
        BeanJsonConverterTest.assertEquals((long)2L, (long)data.size());
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.equals("count")) {
                BeanJsonConverterTest.assertEquals((Object)0, value);
                continue;
            }
            if (!key.equals("favoriteColor")) continue;
            BeanJsonConverterTest.assertEquals((Object)"yellow", value);
        }
    }

    @Test
    public void testJsonToMapWithConversion() throws Exception {
        String jsonActivity = "{count : 0, favoriteColor : 'yellow'}";
        Map data = Maps.newHashMap();
        data = (Map)this.beanJsonConverter.convertToObject(jsonActivity, new TypeLiteral<Map<String, String>>(){}.getType());
        BeanJsonConverterTest.assertEquals((long)2L, (long)data.size());
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.equals("count")) {
                BeanJsonConverterTest.assertEquals((Object)"0", (Object)value);
                continue;
            }
            if (!key.equals("favoriteColor")) continue;
            BeanJsonConverterTest.assertEquals((Object)"yellow", (Object)value);
        }
    }

    @Test
    public void testJsonToNestedGeneric() throws Exception {
        String jsonActivity = "{key0:[0,1,2],key1:[3,4,5]}";
        Map data = (Map)this.beanJsonConverter.convertToObject(jsonActivity, new TypeLiteral<Map<String, List<Integer>>>(){}.getType());
        BeanJsonConverterTest.assertEquals((long)2L, (long)data.size());
        BeanJsonConverterTest.assertEquals(Arrays.asList(0, 1, 2), data.get("key0"));
        BeanJsonConverterTest.assertEquals(Arrays.asList(3, 4, 5), data.get("key1"));
    }

    @Test
    public void testEmptyJsonMap() throws Exception {
        String emptyMap = "{}";
        Map data = (Map)this.beanJsonConverter.convertToObject(emptyMap, new TypeLiteral<Map<String, String>>(){}.getType());
        BeanJsonConverterTest.assertTrue((boolean)data.isEmpty());
    }

    @Test
    public void testEmptyExtendableBean() throws Exception {
        String emptyMap = "{}";
        ExtendableTestObject data = (ExtendableTestObject)this.beanJsonConverter.convertToObject(emptyMap, ExtendableTestObject.class);
        BeanJsonConverterTest.assertTrue((boolean)data.isEmpty());
    }

    @Test
    public void testGetPropertyNameOfBridgeMethod() throws NoSuchMethodException, SecurityException {
        Method bridgeSetter = GenericObject.class.getMethod("setT", Object.class);
        BeanJsonConverterTest.assertNull((Object)BeanJsonConverter.getPropertyName((Method)bridgeSetter));
        Method realSetter = GenericObject.class.getMethod("setT", String.class);
        BeanJsonConverterTest.assertEquals((Object)"t", (Object)BeanJsonConverter.getPropertyName((Method)realSetter));
    }

    public static class ExtendableTestObject
    extends HashMap<String, Object>
    implements ExtendableBean {
        private static final long serialVersionUID = 1L;
    }

    public static class TestObject {
        static String staticValue;
        String hello;
        int count;
        List<TestObject> children;
        TestEnum testEnum;

        public static void setSomeStatic(String staticValue) {
            TestObject.staticValue = staticValue;
        }

        public void setHello(String hello) {
            this.hello = hello;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void setChildren(List<TestObject> children) {
            this.children = children;
        }

        public void setTestEnum(TestEnum testEnum) {
            this.testEnum = testEnum;
        }

        public static enum TestEnum {
            foo,
            bar,
            baz;

        }
    }

    public static class GenericObject
    implements GenericInterface<String> {
        String value;

        @Override
        public void setT(String value) {
            this.value = value;
        }
    }

    public static interface GenericInterface<T> {
        public void setT(T var1);
    }
}

