/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.auth.AuthInfo;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.testing.FakeHttpServletRequest;
import org.apache.shindig.protocol.DataServiceServlet;
import org.apache.shindig.protocol.DefaultHandlerRegistry;
import org.apache.shindig.protocol.HandlerExecutionListener;
import org.apache.shindig.protocol.HandlerRegistry;
import org.apache.shindig.protocol.TestHandler;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.easymock.IMocksControl;
import org.easymock.classextension.EasyMock;

public class DataServiceServletTest
extends TestCase {
    private static final FakeGadgetToken FAKE_GADGET_TOKEN = new FakeGadgetToken().setOwnerId("john.doe").setViewerId("john.doe");
    private HttpServletRequest req;
    private HttpServletResponse res;
    private DataServiceServlet servlet;
    private BeanJsonConverter jsonConverter;
    private BeanConverter xmlConverter;
    private BeanConverter atomConverter;
    private IMocksControl mockControl = EasyMock.createNiceControl();

    protected void setUp() throws Exception {
        this.servlet = new DataServiceServlet();
        this.req = (HttpServletRequest)this.mockControl.createMock(HttpServletRequest.class);
        this.res = (HttpServletResponse)this.mockControl.createMock(HttpServletResponse.class);
        this.jsonConverter = (BeanJsonConverter)this.mockControl.createMock(BeanJsonConverter.class);
        this.xmlConverter = (BeanConverter)this.mockControl.createMock(BeanConverter.class);
        this.atomConverter = (BeanConverter)this.mockControl.createMock(BeanConverter.class);
        EasyMock.expect((Object)this.jsonConverter.getContentType()).andReturn((Object)"application/json").anyTimes();
        EasyMock.expect((Object)this.xmlConverter.getContentType()).andReturn((Object)"application/xml").anyTimes();
        EasyMock.expect((Object)this.atomConverter.getContentType()).andReturn((Object)"application/atom+xml").anyTimes();
        DefaultHandlerRegistry registry = new DefaultHandlerRegistry(null, this.jsonConverter, (HandlerExecutionListener)new HandlerExecutionListener.NoOpHandler());
        registry.addHandlers((Set)Sets.newHashSet((Object[])new Object[]{new TestHandler()}));
        this.servlet.setHandlerRegistry((HandlerRegistry)registry);
        this.servlet.setBeanConverters((BeanConverter)this.jsonConverter, this.xmlConverter, this.atomConverter);
    }

    public void testUriRecognition() throws Exception {
        this.verifyHandlerWasFoundForPathInfo("/test/5/@self");
    }

    private void verifyHandlerWasFoundForPathInfo(String peoplePathInfo) throws Exception {
        String post = "POST";
        this.verifyHandlerWasFoundForPathInfo(peoplePathInfo, post, post);
    }

    private void verifyHandlerWasFoundForPathInfo(String pathInfo, String actualMethod, String overrideMethod) throws Exception {
        this.setupRequest(pathInfo, actualMethod, overrideMethod);
        String method = StringUtils.isEmpty((String)overrideMethod) ? actualMethod : overrideMethod;
        EasyMock.expect((Object)this.jsonConverter.convertToString((Object)ImmutableMap.of((Object)"entry", (Object)TestHandler.REST_RESULTS.get(method)))).andReturn((Object)("{ 'entry' : " + TestHandler.REST_RESULTS.get(method) + " }"));
        PrintWriter writerMock = (PrintWriter)EasyMock.createMock(PrintWriter.class);
        EasyMock.expect((Object)this.res.getWriter()).andReturn((Object)writerMock);
        writerMock.write("GET_RESPONSE");
        EasyMock.expectLastCall();
        this.res.setCharacterEncoding("UTF-8");
        this.res.setContentType("application/json");
        this.mockControl.replay();
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        this.mockControl.verify();
        this.mockControl.reset();
    }

    public void testOverridePostWithGet() throws Exception {
        String route = "/test";
        this.verifyHandlerWasFoundForPathInfo(route, "POST", "GET");
    }

    public void testOverrideGetWithPost() throws Exception {
        String route = "/test";
        this.verifyHandlerWasFoundForPathInfo(route, "GET", "POST");
    }

    public void testFailedRequest() throws Exception {
        String route = "/test";
        this.setupRequest(route, "DELETE", null);
        this.res.sendError(400, "FAILURE_MESSAGE");
        this.res.setCharacterEncoding("UTF-8");
        this.res.setContentType("application/json");
        this.mockControl.replay();
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        this.mockControl.verify();
        this.mockControl.reset();
    }

    private void setupRequest(String pathInfo, String actualMethod, String overrideMethod) throws IOException {
        FakeHttpServletRequest fakeReq = new FakeHttpServletRequest("/social/rest", pathInfo, "");
        fakeReq.setPathInfo(pathInfo);
        fakeReq.setParameter("X-HTTP-Method-Override", overrideMethod);
        fakeReq.setCharacterEncoding("UTF-8");
        if (!"GET".equals(actualMethod) && !"HEAD".equals(actualMethod)) {
            fakeReq.setPostData("", "UTF-8");
        }
        fakeReq.setMethod(actualMethod);
        fakeReq.setAttribute(AuthInfo.Attribute.SECURITY_TOKEN.getId(), FAKE_GADGET_TOKEN);
        fakeReq.setContentType("application/json");
        this.req = fakeReq;
    }

    public void testGetConverterForRequest() throws Exception {
        this.assertConverter(this.atomConverter, "atom");
        this.assertConverter(this.xmlConverter, "xml");
        this.assertConverter((BeanConverter)this.jsonConverter, "");
        this.assertConverter((BeanConverter)this.jsonConverter, null);
        this.assertConverter((BeanConverter)this.jsonConverter, "ahhhh!");
    }

    public void testGetConverterForRequestContentType() throws Exception {
        this.assertConverterForContentType(this.atomConverter, "application/atom+xml");
        this.assertConverterForContentType(this.xmlConverter, "application/xml");
        this.assertConverterForContentType(this.xmlConverter, "text/xml");
        this.assertConverterForContentType((BeanConverter)this.jsonConverter, "application/json");
        this.assertConverterForContentType((BeanConverter)this.jsonConverter, "application/json");
        this.assertConverterForContentType((BeanConverter)this.jsonConverter, "");
        this.assertConverterForContentType((BeanConverter)this.jsonConverter, null);
        this.assertConverterForContentType((BeanConverter)this.jsonConverter, "abcd!");
    }

    private void assertConverter(BeanConverter converter, String format) {
        EasyMock.expect((Object)this.req.getParameter("format")).andReturn((Object)format);
        EasyMock.replay((Object[])new Object[]{this.req});
        DataServiceServletTest.assertEquals((Object)converter, (Object)this.servlet.getConverterForRequest(this.req));
        EasyMock.verify((Object[])new Object[]{this.req});
        EasyMock.reset((Object[])new Object[]{this.req});
    }

    private void assertConverterForContentType(BeanConverter converter, String contentType) {
        EasyMock.expect((Object)this.req.getContentType()).andReturn((Object)contentType);
        EasyMock.replay((Object[])new Object[]{this.req});
        DataServiceServletTest.assertEquals((Object)converter, (Object)this.servlet.getConverterForRequest(this.req));
        EasyMock.verify((Object[])new Object[]{this.req});
        EasyMock.reset((Object[])new Object[]{this.req});
    }
}

