/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.apache.shindig.common.JsonAssert;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.protocol.DefaultHandlerRegistry;
import org.apache.shindig.protocol.HandlerExecutionListener;
import org.apache.shindig.protocol.HandlerRegistry;
import org.apache.shindig.protocol.JsonRpcServlet;
import org.apache.shindig.protocol.RequestItem;
import org.apache.shindig.protocol.ResponseItem;
import org.apache.shindig.protocol.TestHandler;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.protocol.multipart.FormDataItem;
import org.apache.shindig.protocol.multipart.MultipartFormParser;
import org.easymock.IMocksControl;
import org.easymock.classextension.EasyMock;

public class JsonRpcServletTest
extends TestCase {
    private static final FakeGadgetToken FAKE_GADGET_TOKEN = new FakeGadgetToken().setOwnerId("john.doe").setViewerId("john.doe");
    private static final String IMAGE_FIELDNAME = "profile-photo";
    private static final String IMAGE_DATA = "image data";
    private static final byte[] IMAGE_DATA_BYTES = "image data".getBytes();
    private static final String IMAGE_TYPE = "image/jpeg";
    private HttpServletRequest req;
    private HttpServletResponse res;
    private JsonRpcServlet servlet;
    private MultipartFormParser multipartFormParser;
    private final IMocksControl mockControl = EasyMock.createNiceControl();
    private final ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private final PrintWriter writer = new PrintWriter(this.stream);
    private final TestHandler handler = new TestHandler();

    protected void setUp() throws Exception {
        this.servlet = new JsonRpcServlet();
        this.req = (HttpServletRequest)this.mockControl.createMock(HttpServletRequest.class);
        this.res = (HttpServletResponse)this.mockControl.createMock(HttpServletResponse.class);
        this.multipartFormParser = (MultipartFormParser)this.mockControl.createMock(MultipartFormParser.class);
        EasyMock.expect((Object)this.multipartFormParser.isMultipartContent(this.req)).andStubReturn((Object)false);
        this.servlet.setMultipartFormParser(this.multipartFormParser);
        BeanJsonConverter converter = new BeanJsonConverter(Guice.createInjector((Module[])new Module[0]));
        DefaultHandlerRegistry registry = new DefaultHandlerRegistry(null, null, (HandlerExecutionListener)new HandlerExecutionListener.NoOpHandler());
        registry.addHandlers(Collections.singleton(this.handler));
        this.servlet.setHandlerRegistry((HandlerRegistry)registry);
        this.servlet.setBeanConverters((BeanConverter)converter, null, null);
        this.handler.setMock(new TestHandler(){

            public Object get(RequestItem req) {
                return ImmutableMap.of((Object)"foo", (Object)"bar");
            }
        });
    }

    private String getOutput() throws IOException {
        this.writer.close();
        return this.stream.toString("UTF-8");
    }

    public void testMethodRecognition() throws Exception {
        this.setupRequest("{method:test.get,id:id,params:{userId:5,groupId:@self}}");
        org.easymock.EasyMock.expect((Object)this.res.getWriter()).andReturn((Object)this.writer);
        org.easymock.EasyMock.expectLastCall();
        this.mockControl.replay();
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        this.mockControl.verify();
        JsonAssert.assertJsonEquals("{id: 'id', data: {foo:'bar'}}", this.getOutput());
    }

    public void testPostMultipartFormData() throws Exception {
        EasyMock.reset((Object[])new Object[]{this.multipartFormParser});
        this.handler.setMock(new TestHandler(){

            public Object get(RequestItem req) {
                FormDataItem item = req.getFormMimePart(JsonRpcServletTest.IMAGE_FIELDNAME);
                return ImmutableMap.of((Object)"image-data", (Object)new String(item.get()), (Object)"image-type", (Object)item.getContentType(), (Object)"image-ref", (Object)req.getParameter("image-ref"));
            }
        });
        org.easymock.EasyMock.expect((Object)this.req.getMethod()).andStubReturn((Object)"POST");
        org.easymock.EasyMock.expect((Object)this.req.getAttribute((String)org.easymock.EasyMock.isA(String.class))).andReturn((Object)FAKE_GADGET_TOKEN);
        org.easymock.EasyMock.expect((Object)this.req.getCharacterEncoding()).andStubReturn((Object)"UTF-8");
        org.easymock.EasyMock.expect((Object)this.req.getContentType()).andStubReturn((Object)"multipart/form-data");
        this.res.setCharacterEncoding("UTF-8");
        this.res.setContentType("application/json");
        ArrayList formItems = Lists.newArrayList();
        String request = "{method:'test.get',id:'id',params:{userId:5,groupId:'@self',image-ref:'@profile-photo'}}";
        formItems.add(this.mockFormDataItem("request", "application/json", request.getBytes(), true));
        formItems.add(this.mockFormDataItem(IMAGE_FIELDNAME, IMAGE_TYPE, IMAGE_DATA_BYTES, false));
        org.easymock.EasyMock.expect((Object)this.multipartFormParser.isMultipartContent(this.req)).andReturn((Object)true);
        org.easymock.EasyMock.expect((Object)this.multipartFormParser.parse(this.req)).andReturn((Object)formItems);
        org.easymock.EasyMock.expect((Object)this.res.getWriter()).andReturn((Object)this.writer);
        org.easymock.EasyMock.expectLastCall();
        this.mockControl.replay();
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        this.mockControl.verify();
        JsonAssert.assertJsonEquals("{id: 'id', data: {image-data:'image data', image-type:'image/jpeg', image-ref:'@profile-photo'}}", this.getOutput());
    }

    public void testPostMultipartFormDataWithRequestFieldHavingNoContentType() throws Exception {
        EasyMock.reset((Object[])new Object[]{this.multipartFormParser});
        this.handler.setMock(new TestHandler(){

            public Object get(RequestItem req) {
                FormDataItem item = req.getFormMimePart(JsonRpcServletTest.IMAGE_FIELDNAME);
                return ImmutableMap.of((Object)"image-data", (Object)new String(item.get()), (Object)"image-type", (Object)item.getContentType(), (Object)"image-ref", (Object)req.getParameter("image-ref"));
            }
        });
        org.easymock.EasyMock.expect((Object)this.req.getMethod()).andStubReturn((Object)"POST");
        org.easymock.EasyMock.expect((Object)this.req.getAttribute((String)org.easymock.EasyMock.isA(String.class))).andReturn((Object)FAKE_GADGET_TOKEN);
        org.easymock.EasyMock.expect((Object)this.req.getCharacterEncoding()).andStubReturn((Object)"UTF-8");
        org.easymock.EasyMock.expect((Object)this.req.getContentType()).andStubReturn((Object)"multipart/form-data");
        this.res.setCharacterEncoding("UTF-8");
        this.res.setContentType("application/json");
        ArrayList formItems = Lists.newArrayList();
        String request = "{method:'test.get',id:'id',params:{userId:5,groupId:'@self',image-ref:'@profile-photo'}}";
        formItems.add(this.mockFormDataItem(IMAGE_FIELDNAME, IMAGE_TYPE, IMAGE_DATA_BYTES, false));
        formItems.add(this.mockFormDataItem("request", null, request.getBytes(), true));
        org.easymock.EasyMock.expect((Object)this.multipartFormParser.isMultipartContent(this.req)).andReturn((Object)true);
        org.easymock.EasyMock.expect((Object)this.multipartFormParser.parse(this.req)).andReturn((Object)formItems);
        org.easymock.EasyMock.expect((Object)this.res.getWriter()).andReturn((Object)this.writer);
        org.easymock.EasyMock.expectLastCall();
        this.mockControl.replay();
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        this.mockControl.verify();
        JsonAssert.assertJsonEquals("{id: 'id', data: {image-data:'image data', image-type:'image/jpeg', image-ref:'@profile-photo'}}", this.getOutput());
    }

    public void testPostMultipartFormDataOnlyRequestFieldHasContentTypeChecked() throws Exception {
        EasyMock.reset((Object[])new Object[]{this.multipartFormParser});
        this.handler.setMock(new TestHandler(){

            public Object get(RequestItem req) {
                FormDataItem item = req.getFormMimePart(JsonRpcServletTest.IMAGE_FIELDNAME);
                return ImmutableMap.of((Object)"image-data", (Object)new String(item.get()), (Object)"image-type", (Object)item.getContentType(), (Object)"image-ref", (Object)req.getParameter("image-ref"));
            }
        });
        org.easymock.EasyMock.expect((Object)this.req.getMethod()).andStubReturn((Object)"POST");
        org.easymock.EasyMock.expect((Object)this.req.getAttribute((String)org.easymock.EasyMock.isA(String.class))).andReturn((Object)FAKE_GADGET_TOKEN);
        org.easymock.EasyMock.expect((Object)this.req.getCharacterEncoding()).andStubReturn((Object)"UTF-8");
        org.easymock.EasyMock.expect((Object)this.req.getContentType()).andStubReturn((Object)"multipart/form-data");
        this.res.setCharacterEncoding("UTF-8");
        this.res.setContentType("application/json");
        ArrayList formItems = Lists.newArrayList();
        String request = "{method:'test.get',id:'id',params:{userId:5,groupId:'@self',image-ref:'@profile-photo'}}";
        formItems.add(this.mockFormDataItem(IMAGE_FIELDNAME, IMAGE_TYPE, IMAGE_DATA_BYTES, false));
        formItems.add(this.mockFormDataItem("oauth_hash", "application/octet-stream", "oauth-hash".getBytes(), true));
        formItems.add(this.mockFormDataItem("request", null, request.getBytes(), true));
        formItems.add(this.mockFormDataItem("oauth_signature", "application/octet-stream", "oauth_signature".getBytes(), true));
        org.easymock.EasyMock.expect((Object)this.multipartFormParser.isMultipartContent(this.req)).andReturn((Object)true);
        org.easymock.EasyMock.expect((Object)this.multipartFormParser.parse(this.req)).andReturn((Object)formItems);
        org.easymock.EasyMock.expect((Object)this.res.getWriter()).andReturn((Object)this.writer);
        org.easymock.EasyMock.expectLastCall();
        this.mockControl.replay();
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        this.mockControl.verify();
        JsonAssert.assertJsonEquals("{id: 'id', data: {image-data:'image data', image-type:'image/jpeg', image-ref:'@profile-photo'}}", this.getOutput());
    }

    public void testPostMultipartFormDataRequestFieldIsSubjectedToContentTypeCheck() throws Exception {
        EasyMock.reset((Object[])new Object[]{this.multipartFormParser});
        this.handler.setMock(new TestHandler(){

            public Object get(RequestItem req) {
                FormDataItem item = req.getFormMimePart(JsonRpcServletTest.IMAGE_FIELDNAME);
                return ImmutableMap.of((Object)"image-data", (Object)item.get(), (Object)"image-type", (Object)item.getContentType(), (Object)"image-ref", (Object)req.getParameter("image-ref"));
            }
        });
        org.easymock.EasyMock.expect((Object)this.req.getMethod()).andStubReturn((Object)"POST");
        org.easymock.EasyMock.expect((Object)this.req.getAttribute((String)org.easymock.EasyMock.isA(String.class))).andReturn((Object)FAKE_GADGET_TOKEN);
        org.easymock.EasyMock.expect((Object)this.req.getCharacterEncoding()).andStubReturn((Object)"UTF-8");
        org.easymock.EasyMock.expect((Object)this.req.getContentType()).andStubReturn((Object)"multipart/form-data");
        this.res.setCharacterEncoding("UTF-8");
        this.res.setContentType("application/json");
        ArrayList formItems = Lists.newArrayList();
        String request = "{method:'test.get',id:'id',params:{userId:5,groupId:'@self',image-ref:'@profile-photo'}}";
        formItems.add(this.mockFormDataItem(IMAGE_FIELDNAME, IMAGE_TYPE, IMAGE_DATA_BYTES, false));
        formItems.add(this.mockFormDataItem("request", "application/octet-stream", request.getBytes(), true));
        org.easymock.EasyMock.expect((Object)this.multipartFormParser.isMultipartContent(this.req)).andReturn((Object)true);
        org.easymock.EasyMock.expect((Object)this.multipartFormParser.parse(this.req)).andReturn((Object)formItems);
        org.easymock.EasyMock.expect((Object)this.res.getWriter()).andReturn((Object)this.writer);
        org.easymock.EasyMock.expectLastCall();
        this.mockControl.replay();
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        this.mockControl.verify();
        String output = this.getOutput();
        JsonRpcServletTest.assertTrue((-1 != output.indexOf("Unsupported Content-Type application/octet-stream") ? 1 : 0) != 0);
    }

    public void testInvalidService() throws Exception {
        this.setupRequest("{method:junk.get,id:id,params:{userId:5,groupId:@self}}");
        org.easymock.EasyMock.expect((Object)this.res.getWriter()).andReturn((Object)this.writer);
        org.easymock.EasyMock.expectLastCall();
        this.mockControl.replay();
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        this.mockControl.verify();
        JsonAssert.assertJsonEquals("{id:id,error:{message:'notImplemented: The method junk.get is not implemented',code:501}}", this.getOutput());
    }

    public void testFailedRequest() throws Exception {
        this.setupRequest("{id:id,method:test.futureException}");
        org.easymock.EasyMock.expect((Object)this.res.getWriter()).andReturn((Object)this.writer);
        org.easymock.EasyMock.expectLastCall();
        this.mockControl.replay();
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        this.mockControl.verify();
        JsonAssert.assertJsonEquals("{id:id,error:{message:'badRequest: FAILURE_MESSAGE',code:400}}", this.getOutput());
    }

    public void testBasicBatch() throws Exception {
        this.setupRequest("[{method:test.get,id:'1'},{method:test.get,id:'2'}]");
        org.easymock.EasyMock.expect((Object)this.res.getWriter()).andReturn((Object)this.writer);
        org.easymock.EasyMock.expectLastCall();
        this.mockControl.replay();
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        this.mockControl.verify();
        JsonAssert.assertJsonEquals("[{id:'1',data:{foo:'bar'}},{id:'2',data:{foo:'bar'}}]", this.getOutput());
    }

    public void testGetExecution() throws Exception {
        org.easymock.EasyMock.expect((Object)this.req.getParameterMap()).andStubReturn((Object)ImmutableMap.of((Object)"method", (Object)new String[]{"test.get"}, (Object)"id", (Object)new String[]{"1"}));
        org.easymock.EasyMock.expect((Object)this.req.getMethod()).andStubReturn((Object)"GET");
        org.easymock.EasyMock.expect((Object)this.req.getAttribute((String)org.easymock.EasyMock.isA(String.class))).andReturn((Object)FAKE_GADGET_TOKEN);
        org.easymock.EasyMock.expect((Object)this.req.getCharacterEncoding()).andStubReturn((Object)"UTF-8");
        this.res.setCharacterEncoding("UTF-8");
        org.easymock.EasyMock.expect((Object)this.res.getWriter()).andReturn((Object)this.writer);
        org.easymock.EasyMock.expectLastCall();
        this.mockControl.replay();
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.res);
        this.mockControl.verify();
        JsonAssert.assertJsonEquals("{id:'1',data:{foo:'bar'}}", this.getOutput());
    }

    public void testGetJsonResponseWithKey() throws Exception {
        ResponseItem responseItem = new ResponseItem((Object)"Name");
        Object result = this.servlet.getJSONResponse("my-key", responseItem);
        JsonAssert.assertObjectEquals("{id: 'my-key', data: 'Name'}", result);
    }

    public void testGetJsonResponseWithoutKey() throws Exception {
        ResponseItem responseItem = new ResponseItem((Object)"Name");
        Object result = this.servlet.getJSONResponse(null, responseItem);
        JsonAssert.assertObjectEquals("{data: 'Name'}", result);
    }

    public void testGetJsonResponseErrorWithData() throws Exception {
        ResponseItem responseItem = new ResponseItem(401, "Error Message", (Object)"Optional Data");
        Object result = this.servlet.getJSONResponse(null, responseItem);
        JsonAssert.assertObjectEquals("{error: {message: 'unauthorized: Error Message', data: 'Optional Data', code: 401}}", result);
    }

    public void testGetJsonResponseErrorWithoutData() throws Exception {
        ResponseItem responseItem = new ResponseItem(401, "Error Message");
        Object result = this.servlet.getJSONResponse(null, responseItem);
        JsonAssert.assertObjectEquals("{error: {message:'unauthorized: Error Message', code:401}}", result);
    }

    private void setupRequest(String json) throws IOException {
        final ByteArrayInputStream in = new ByteArrayInputStream(json.getBytes());
        ServletInputStream stream = new ServletInputStream(){

            public int read() throws IOException {
                return in.read();
            }
        };
        org.easymock.EasyMock.expect((Object)this.req.getInputStream()).andStubReturn((Object)stream);
        org.easymock.EasyMock.expect((Object)this.req.getMethod()).andStubReturn((Object)"POST");
        org.easymock.EasyMock.expect((Object)this.req.getAttribute((String)org.easymock.EasyMock.isA(String.class))).andReturn((Object)FAKE_GADGET_TOKEN);
        org.easymock.EasyMock.expect((Object)this.req.getCharacterEncoding()).andStubReturn((Object)"UTF-8");
        org.easymock.EasyMock.expect((Object)this.req.getContentType()).andStubReturn((Object)"application/json");
        this.res.setCharacterEncoding("UTF-8");
        this.res.setContentType("application/json");
    }

    private FormDataItem mockFormDataItem(String fieldName, String contentType, byte[] content, boolean isFormField) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        FormDataItem formDataItem = (FormDataItem)this.mockControl.createMock(FormDataItem.class);
        org.easymock.EasyMock.expect((Object)formDataItem.getContentType()).andStubReturn((Object)contentType);
        org.easymock.EasyMock.expect((Object)formDataItem.getSize()).andStubReturn((Object)content.length);
        org.easymock.EasyMock.expect((Object)formDataItem.get()).andStubReturn((Object)content);
        org.easymock.EasyMock.expect((Object)formDataItem.getAsString()).andStubReturn((Object)new String(content));
        org.easymock.EasyMock.expect((Object)formDataItem.getFieldName()).andStubReturn((Object)fieldName);
        org.easymock.EasyMock.expect((Object)formDataItem.isFormField()).andStubReturn((Object)isFormField);
        org.easymock.EasyMock.expect((Object)formDataItem.getInputStream()).andStubReturn((Object)in);
        return formDataItem;
    }
}

