/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import net.sf.json.JSONObject;
import org.apache.shindig.protocol.conversion.BeanJsonLibConverter;
import org.apache.shindig.protocol.conversion.jsonlib.ApiValidator;
import org.apache.shindig.protocol.conversion.jsonlib.JsonLibTestsGuiceModule;
import org.apache.shindig.protocol.model.TestModel;

public class BeanJsonLibConverterTest
extends TestCase {
    private TestModel.Car car;
    private BeanJsonLibConverter beanJsonConverter;

    public void setUp() throws Exception {
        super.setUp();
        this.car = new TestModel.Car();
        Injector injector = Guice.createInjector((Module[])new Module[]{new JsonLibTestsGuiceModule()});
        this.beanJsonConverter = (BeanJsonLibConverter)injector.getInstance(BeanJsonLibConverter.class);
    }

    public void testToJsonOnInheritedClass() throws Exception {
        TestModel.ExpensiveCar roller = new TestModel.ExpensiveCar();
        JSONObject result = this.beanJsonConverter.convertToJson((Object)roller);
        BeanJsonLibConverterTest.assertEquals((int)roller.getCost(), (int)result.getInt("cost"));
        BeanJsonLibConverterTest.assertEquals((int)roller.getParkingTickets().size(), (int)result.getJSONObject("parkingTickets").size());
    }

    public void testCarToJson() throws Exception {
        JSONObject object = this.beanJsonConverter.convertToJson((Object)this.car);
        BeanJsonLibConverterTest.assertEquals((Object)object, (Object)JSONObject.fromObject((Object)"{\"engine\":[{\"value\":\"GAS\"},{\"value\":\"HYBRID\"}],\"parkingTickets\":{\"TOKYO\":\"250Y\",\"BERKELEY\":\"$120\"},\"passengers\":[{\"gender\":\"male\",\"name\":\"Dick Dastardly\"},{\"gender\":\"female\",\"name\":\"Speed Racer\"}]}"));
    }

    public void testMapsToJson() throws Exception {
        HashMap map = Maps.newHashMap();
        HashMap item1Map = Maps.newHashMap();
        item1Map.put("value", "1");
        item1Map.put("value2", null);
        map.put("item1", item1Map);
        HashMap item2Map = Maps.newHashMap();
        item2Map.put("value", "2");
        map.put("item2", item2Map);
        String result = this.beanJsonConverter.convertToString((Object)map);
        this.beanJsonConverter.addMapping("item1", Map.class);
        this.beanJsonConverter.addMapping("item2", Map.class);
        Map parsedMap = (Map)this.beanJsonConverter.convertToObject(result, Map.class);
        ApiValidator.dump(parsedMap);
        BeanJsonLibConverterTest.assertEquals((Object)"1", ((Map)parsedMap.get("item1")).get("value"));
        BeanJsonLibConverterTest.assertEquals((Object)"2", ((Map)parsedMap.get("item2")).get("value"));
    }

    public void testListsToJson() throws Exception {
        HashMap item1Map = Maps.newHashMap();
        item1Map.put("value", "1");
        HashMap item2Map = Maps.newHashMap();
        item2Map.put("value", "2");
        ArrayList list = Lists.newArrayList();
        list.add(item1Map);
        list.add(item2Map);
        String result = this.beanJsonConverter.convertToString((Object)list);
        Map[] parsedList = (Map[])this.beanJsonConverter.convertToObject(result, Map[].class);
        BeanJsonLibConverterTest.assertEquals((Object)"1", parsedList[0].get("value"));
        BeanJsonLibConverterTest.assertEquals((Object)"2", parsedList[1].get("value"));
    }

    public void testArrayToJson() throws Exception {
        String[] colors = new String[]{"blue", "green", "aquamarine"};
        String result = this.beanJsonConverter.convertToString((Object)colors);
        String[] parsedColors = (String[])this.beanJsonConverter.convertToObject(result, String[].class);
        BeanJsonLibConverterTest.assertEquals((int)colors.length, (int)parsedColors.length);
        BeanJsonLibConverterTest.assertEquals((String)colors[0], (String)parsedColors[0]);
        BeanJsonLibConverterTest.assertEquals((String)colors[1], (String)parsedColors[1]);
        BeanJsonLibConverterTest.assertEquals((String)colors[2], (String)parsedColors[2]);
    }

    public void testJsonToMap() throws Exception {
        String jsonActivity = "{count : 0, favoriteColor : 'yellow'}";
        Map data = Maps.newHashMap();
        data = (Map)this.beanJsonConverter.convertToObject(jsonActivity, data.getClass());
        BeanJsonLibConverterTest.assertEquals((int)2, (int)data.size());
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.equals("count")) {
                BeanJsonLibConverterTest.assertEquals((Object)0, value);
                continue;
            }
            if (!key.equals("favoriteColor")) continue;
            BeanJsonLibConverterTest.assertEquals((Object)"yellow", value);
        }
    }

    public void testEmptyObject() {
        BeanJsonLibConverterTest.assertEquals((String)"{}", (String)this.beanJsonConverter.convertToString((Object)""));
        BeanJsonLibConverterTest.assertEquals((int)0, (int)((Map)this.beanJsonConverter.convertToObject("", Map.class)).size());
        BeanJsonLibConverterTest.assertEquals((int)0, (int)((String[])this.beanJsonConverter.convertToObject("[]", String[].class)).length);
        BeanJsonLibConverterTest.assertEquals((int)2, (int)((String[])this.beanJsonConverter.convertToObject("[\"a\",\"b\"]", String[].class)).length);
    }
}

