/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.protocol.conversion.BeanXmlConverter;
import org.apache.shindig.protocol.model.TestModel;

public class BeanXmlConverterTest
extends TestCase {
    private TestModel.Car car;
    private BeanXmlConverter beanXmlConverter;

    public void setUp() throws Exception {
        super.setUp();
        this.car = new TestModel.Car();
        this.beanXmlConverter = new BeanXmlConverter();
    }

    public void testCarToXml() throws Exception {
        String xml = this.beanXmlConverter.convertToXml((Object)this.car);
        BeanXmlConverterTest.assertEquals((String)xml, (String)"<response><engine><EnumImpl><value><declaringClass>org.apache.shindig.protocol.model.TestModel$Engine</declaringClass><displayValue>Gas</displayValue></value></EnumImpl><EnumImpl><value><declaringClass>org.apache.shindig.protocol.model.TestModel$Engine</declaringClass><displayValue>Hybrid</displayValue></value></EnumImpl></engine><parkingTickets><entry><key>TOKYO</key><value>250Y</value></entry><entry><key>BERKELEY</key><value>$120</value></entry></parkingTickets><passengers><TestModelPassenger><gender><declaringClass>org.apache.shindig.protocol.model.TestModel$Gender</declaringClass></gender><name>Dick Dastardly</name></TestModelPassenger><TestModelPassenger><gender><declaringClass>org.apache.shindig.protocol.model.TestModel$Gender</declaringClass></gender><name>Speed Racer</name></TestModelPassenger></passengers></response>");
    }

    public void xxxtestMapsToXml() throws Exception {
        TreeMap map = Maps.newTreeMap();
        ImmutableMap item1Map = ImmutableMap.of((Object)"value", (Object)"1");
        map.put("item1", item1Map);
        ImmutableMap item2Map = ImmutableMap.of((Object)"value", (Object)"2");
        map.put("item2", item2Map);
        String xml = this.beanXmlConverter.convertToXml((Object)map);
        XmlUtil.parse((String)xml);
        String expectedXml = "<treemap><empty>false</empty><entry><key>item1</key><value><empty>false</empty><entry><key>value</key><value>1</value></entry></value></entry><entry><key>item2</key><value><empty>false</empty><entry><key>value</key><value>2</value></entry></value></entry></treemap>";
        BeanXmlConverterTest.assertEquals((String)expectedXml, (String)StringUtils.deleteWhitespace((String)xml));
    }
}

