/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import junit.framework.TestCase;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;

public class BeanJsonConverterInjectedClassTest
extends TestCase {
    private BeanJsonConverter beanJsonConverter;

    public void setUp() throws Exception {
        super.setUp();
        this.beanJsonConverter = new BeanJsonConverter(Guice.createInjector((Module[])new Module[]{new TestModule()}));
    }

    public void testJsonToObject() throws Exception {
        String json = "{x:'xValue',y:'yValue'}";
        TestObject object = (TestObject)this.beanJsonConverter.convertToObject(json, TestInterface.class);
        BeanJsonConverterInjectedClassTest.assertNotNull((String)"expected 'x' field not set after json conversion", (Object)object.getX());
        BeanJsonConverterInjectedClassTest.assertNotNull((String)"expected 'y' field not set after json conversion", (Object)object.getY());
    }

    public static class TestObject
    implements TestInterface {
        private String x;
        private String y;

        public String getX() {
            return this.x;
        }

        public void setX(String x) {
            this.x = x;
        }

        public String getY() {
            return this.y;
        }

        public void setY(String y) {
            this.y = y;
        }
    }

    public static interface TestInterface {
        public String getX();

        public void setX(String var1);
    }

    private static class TestModule
    extends AbstractModule {
        private TestModule() {
        }

        protected void configure() {
            this.bind(TestInterface.class).to(TestObject.class);
        }
    }
}

