/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.protocol.model.Enum;
import org.apache.shindig.protocol.model.TestModel;

public class BeanJsonConverterTest
extends TestCase {
    private BeanJsonConverter beanJsonConverter;

    public void setUp() throws Exception {
        super.setUp();
        this.beanJsonConverter = new BeanJsonConverter(Guice.createInjector((Module[])new Module[0]));
    }

    public void testJsonToObject() throws Exception {
        String json = "{hello:'world',count:10,someStatic:'foo',testEnum:'bar',children:[{hello:'world-2',count:11},{hello:'world-3',count:12}]}";
        TestObject object = (TestObject)this.beanJsonConverter.convertToObject(json, TestObject.class);
        BeanJsonConverterTest.assertEquals((String)"world", (String)object.hello);
        BeanJsonConverterTest.assertEquals((int)10, (int)object.count);
        BeanJsonConverterTest.assertEquals((String)"world-2", (String)object.children.get((int)0).hello);
        BeanJsonConverterTest.assertEquals((int)11, (int)object.children.get((int)0).count);
        BeanJsonConverterTest.assertEquals((String)"world-3", (String)object.children.get((int)1).hello);
        BeanJsonConverterTest.assertEquals((int)12, (int)object.children.get((int)1).count);
        BeanJsonConverterTest.assertNull((String)"Should not set static values", (Object)TestObject.staticValue);
        BeanJsonConverterTest.assertEquals((Object)((Object)TestObject.TestEnum.bar), (Object)((Object)object.testEnum));
    }

    public void testJsonToPrimitives() throws Exception {
        String simpleJson = "{hello:'world',count:10}";
        Object object = this.beanJsonConverter.convertToObject(simpleJson, null);
        Map map = (Map)object;
        BeanJsonConverterTest.assertEquals((Object)"world", map.get("hello"));
        BeanJsonConverterTest.assertEquals((Object)10, map.get("count"));
    }

    public void testJsonToCar() throws Exception {
        String carJson = "{engine:[{value:DIESEL},{value:TURBO}],parkingTickets:{SF:$137,NY:'$301'},passengers:[{gender:female,name:'Mum'}, {gender:male,name:'Dad'}]}";
        TestModel.Car car = (TestModel.Car)this.beanJsonConverter.convertToObject(carJson, TestModel.Car.class);
        ArrayList engineInfo = Lists.newArrayList((Object[])new TestModel.Engine[]{TestModel.Engine.DIESEL, TestModel.Engine.TURBO});
        for (int i = 0; i < car.getEngine().size(); ++i) {
            BeanJsonConverterTest.assertEquals((Object)((Enum)car.getEngine().get(i)).getValue(), engineInfo.get(i));
        }
        BeanJsonConverterTest.assertEquals((Object)car.getParkingTickets(), (Object)ImmutableMap.of((Object)"SF", (Object)"$137", (Object)"NY", (Object)"$301"));
        TestModel.Passenger mum = (TestModel.Passenger)car.getPassengers().get(0);
        BeanJsonConverterTest.assertEquals((Object)mum.getGender(), (Object)TestModel.Gender.female);
        BeanJsonConverterTest.assertEquals((String)mum.getName(), (String)"Mum");
        TestModel.Passenger dad = (TestModel.Passenger)car.getPassengers().get(1);
        BeanJsonConverterTest.assertEquals((Object)dad.getGender(), (Object)TestModel.Gender.male);
        BeanJsonConverterTest.assertEquals((String)dad.getName(), (String)"Dad");
    }

    public void testJsonToMap() throws Exception {
        String jsonActivity = "{count : 0, favoriteColor : 'yellow'}";
        Map data = Maps.newHashMap();
        data = (Map)this.beanJsonConverter.convertToObject(jsonActivity, new TypeLiteral<Map<String, Object>>(){}.getType());
        BeanJsonConverterTest.assertEquals((int)2, (int)data.size());
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.equals("count")) {
                BeanJsonConverterTest.assertEquals((Object)0, value);
                continue;
            }
            if (!key.equals("favoriteColor")) continue;
            BeanJsonConverterTest.assertEquals((Object)"yellow", value);
        }
    }

    public void testJsonToMapWithConversion() throws Exception {
        String jsonActivity = "{count : 0, favoriteColor : 'yellow'}";
        Map data = Maps.newHashMap();
        data = (Map)this.beanJsonConverter.convertToObject(jsonActivity, new TypeLiteral<Map<String, String>>(){}.getType());
        BeanJsonConverterTest.assertEquals((int)2, (int)data.size());
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.equals("count")) {
                BeanJsonConverterTest.assertEquals((String)"0", (String)value);
                continue;
            }
            if (!key.equals("favoriteColor")) continue;
            BeanJsonConverterTest.assertEquals((String)"yellow", (String)value);
        }
    }

    public void testJsonToNestedGeneric() throws Exception {
        String jsonActivity = "{key0:[0,1,2],key1:[3,4,5]}";
        Map data = Maps.newHashMap();
        data = (Map)this.beanJsonConverter.convertToObject(jsonActivity, new TypeLiteral<Map<String, List<Integer>>>(){}.getType());
        BeanJsonConverterTest.assertEquals((int)2, (int)data.size());
        BeanJsonConverterTest.assertEquals(Arrays.asList(0, 1, 2), data.get("key0"));
        BeanJsonConverterTest.assertEquals(Arrays.asList(3, 4, 5), data.get("key1"));
    }

    public void testEmptyJsonMap() throws Exception {
        String emptyMap = "{}";
        Map data = (Map)this.beanJsonConverter.convertToObject(emptyMap, new TypeLiteral<Map<String, String>>(){}.getType());
        BeanJsonConverterTest.assertTrue((data.size() == 0 ? 1 : 0) != 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestObject {
        static String staticValue;
        String hello;
        int count;
        List<TestObject> children;
        TestEnum testEnum;

        public static void setSomeStatic(String staticValue) {
            TestObject.staticValue = staticValue;
        }

        public void setHello(String hello) {
            this.hello = hello;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void setChildren(List<TestObject> children) {
            this.children = children;
        }

        public void setTestEnum(TestEnum testEnum) {
            this.testEnum = testEnum;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum TestEnum {
            foo,
            bar,
            baz;

        }
    }
}

