/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.name.Names;
import com.google.inject.spi.Message;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.apache.shindig.common.util.ResourceLoader;

public class PropertiesModule
extends AbstractModule {
    private static final String DEFAULT_PROPERTIES = "shindig.properties";
    private final Properties properties;

    public PropertiesModule() {
        InputStream is = null;
        try {
            is = ResourceLoader.openResource(DEFAULT_PROPERTIES);
            this.properties = new Properties();
            this.properties.load(is);
        }
        catch (IOException e) {
            throw new CreationException(Arrays.asList(new Message("Unable to load properties: shindig.properties")));
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public PropertiesModule(Properties properties) {
        this.properties = properties;
    }

    protected void configure() {
        Names.bindProperties((Binder)this.binder(), (Properties)this.properties);
    }
}

