/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.preload;

import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.preload.ConcurrentPreloads;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.preload.Preloader;
import org.apache.shindig.gadgets.preload.PreloaderService;
import org.apache.shindig.gadgets.preload.Preloads;
import org.apache.shindig.gadgets.spec.GadgetSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentPreloaderService
implements PreloaderService {
    private final ExecutorService executor;
    private final List<? extends Preloader> preloaders;

    @Inject
    public ConcurrentPreloaderService(ExecutorService executor, List<Preloader> preloaders) {
        this.executor = executor;
        this.preloaders = preloaders;
    }

    @Override
    public Preloads preload(GadgetContext context, GadgetSpec gadget) {
        ConcurrentPreloads preloads = new ConcurrentPreloads();
        for (Preloader preloader : this.preloaders) {
            Map<String, Callable<PreloadedData>> tasks = preloader.createPreloadTasks(context, gadget);
            for (Map.Entry<String, Callable<PreloadedData>> entry : tasks.entrySet()) {
                preloads.add(entry.getKey(), this.executor.submit(entry.getValue()));
            }
        }
        return preloads;
    }
}

