/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewriterResults;

public class CaptureRewriter
implements ContentRewriter {
    private boolean rewroteView = false;
    private boolean rewroteResponse = false;
    private long cacheTtl = -1L;

    public RewriterResults rewrite(HttpRequest request, HttpResponse original, MutableContent content) {
        this.rewroteResponse = true;
        return this.results();
    }

    public boolean responseWasRewritten() {
        return this.rewroteResponse;
    }

    public RewriterResults rewrite(Gadget gadget, MutableContent content) {
        this.rewroteView = true;
        return this.results();
    }

    public boolean viewWasRewritten() {
        return this.rewroteView;
    }

    private RewriterResults results() {
        if (this.cacheTtl == -1L) {
            return RewriterResults.cacheableIndefinitely();
        }
        return RewriterResults.cacheable(this.cacheTtl);
    }

    public void setCacheTtl(long cacheTtl) {
        this.cacheTtl = cacheTtl;
    }
}

