/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.Icon;
import org.apache.shindig.gadgets.spec.LinkSpec;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.OAuthSpec;
import org.apache.shindig.gadgets.spec.Preload;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModulePrefs {
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_TITLE_URL = "title_url";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_AUTHOR = "author";
    private static final String ATTR_AUTHOR_EMAIL = "author_email";
    private static final String ATTR_SCREENSHOT = "screenshot";
    private static final String ATTR_THUMBNAIL = "thumbnail";
    private static final String ATTR_DIRECTORY_TITLE = "directory_title";
    private static final String ATTR_AUTHOR_AFFILIATION = "author_affiliation";
    private static final String ATTR_AUTHOR_LOCATION = "author_location";
    private static final String ATTR_AUTHOR_PHOTO = "author_photo";
    private static final String ATTR_AUTHOR_ABOUTME = "author_aboutme";
    private static final String ATTR_AUTHOR_QUOTE = "author_quote";
    private static final String ATTR_AUTHOR_LINK = "author_link";
    private static final String ATTR_SHOW_STATS = "show_stats";
    private static final String ATTR_SHOW_IN_DIRECTORY = "show_in_directory";
    private static final String ATTR_SINGLETON = "singleton";
    private static final String ATTR_SCALING = "scaling";
    private static final String ATTR_SCROLLING = "scrolling";
    private static final String ATTR_WIDTH = "width";
    private static final String ATTR_HEIGHT = "height";
    private static final String ATTR_CATEGORY = "category";
    private static final String ATTR_CATEGORY2 = "category2";
    private static final Uri EMPTY_URI = Uri.parse((String)"");
    private final Map<String, String> attributes;
    private final Uri base;
    private final List<String> categories;
    private final Map<String, Feature> features;
    private final List<Preload> preloads;
    private final List<Icon> icons;
    private final Map<Locale, LocaleSpec> locales;
    private final Map<String, LinkSpec> links;
    private final OAuthSpec oauth;

    public ModulePrefs(Element element, Uri base) throws SpecParserException {
        this.base = base;
        this.attributes = new HashMap<String, String>();
        NamedNodeMap attributeNodes = element.getAttributes();
        for (int i = 0; i < attributeNodes.getLength(); ++i) {
            Node node = attributeNodes.item(i);
            this.attributes.put(node.getNodeName(), node.getNodeValue());
        }
        if (this.getTitle() == null) {
            throw new SpecParserException("ModulePrefs@title is required.");
        }
        this.categories = Arrays.asList(this.getAttribute(ATTR_CATEGORY, ""), this.getAttribute(ATTR_CATEGORY2, ""));
        PreloadVisitor preloadVisitor = new PreloadVisitor();
        FeatureVisitor featureVisitor = new FeatureVisitor();
        OAuthVisitor oauthVisitor = new OAuthVisitor();
        IconVisitor iconVisitor = new IconVisitor();
        LocaleVisitor localeVisitor = new LocaleVisitor();
        LinkVisitor linkVisitor = new LinkVisitor();
        HashMap visitors = Maps.newHashMapWithExpectedSize((int)6);
        visitors.put("Preload", preloadVisitor);
        visitors.put("Optional", featureVisitor);
        visitors.put("Require", featureVisitor);
        visitors.put("OAuth", oauthVisitor);
        visitors.put("Icon", iconVisitor);
        visitors.put("Locale", localeVisitor);
        visitors.put("Link", linkVisitor);
        ModulePrefs.walk(element, visitors);
        this.preloads = Collections.unmodifiableList(preloadVisitor.preloaded);
        this.features = Collections.unmodifiableMap(featureVisitor.features);
        this.icons = Collections.unmodifiableList(iconVisitor.icons);
        this.locales = Collections.unmodifiableMap(localeVisitor.localeMap);
        this.links = Collections.unmodifiableMap(linkVisitor.linkMap);
        this.oauth = oauthVisitor.oauthSpec;
    }

    private ModulePrefs(ModulePrefs prefs, Substitutions substituter) {
        this.base = prefs.base;
        this.categories = prefs.getCategories();
        this.features = prefs.getFeatures();
        this.locales = prefs.getLocales();
        this.oauth = prefs.oauth;
        ArrayList<Preload> preloads = new ArrayList<Preload>(prefs.preloads.size());
        for (Preload preload : prefs.preloads) {
            preloads.add(preload.substitute(substituter));
        }
        this.preloads = Collections.unmodifiableList(preloads);
        ArrayList<Icon> icons = new ArrayList<Icon>(prefs.icons.size());
        for (Icon icon : prefs.icons) {
            icons.add(icon.substitute(substituter));
        }
        this.icons = Collections.unmodifiableList(icons);
        HashMap<String, LinkSpec> links = new HashMap<String, LinkSpec>(prefs.links.size());
        for (LinkSpec link : prefs.links.values()) {
            LinkSpec sub = link.substitute(substituter);
            links.put(sub.getRel(), sub);
        }
        this.links = Collections.unmodifiableMap(links);
        HashMap<String, String> attributes = new HashMap<String, String>(prefs.attributes.size());
        for (Map.Entry<String, String> attr : prefs.attributes.entrySet()) {
            String substituted = substituter.substituteString(attr.getValue());
            attributes.put(attr.getKey(), substituted);
        }
        this.attributes = Collections.unmodifiableMap(attributes);
    }

    public String getTitle() {
        return this.getAttribute(ATTR_TITLE);
    }

    public Uri getTitleUrl() {
        return this.getUriAttribute(ATTR_TITLE_URL);
    }

    public String getDescription() {
        return this.getAttribute(ATTR_DESCRIPTION);
    }

    public String getAuthor() {
        return this.getAttribute(ATTR_AUTHOR);
    }

    public String getAuthorEmail() {
        return this.getAttribute(ATTR_AUTHOR_EMAIL);
    }

    public Uri getScreenshot() {
        return this.getUriAttribute(ATTR_SCREENSHOT);
    }

    public Uri getThumbnail() {
        return this.getUriAttribute(ATTR_THUMBNAIL);
    }

    public String getDirectoryTitle() {
        return this.getAttribute(ATTR_DIRECTORY_TITLE);
    }

    public String getAuthorAffiliation() {
        return this.getAttribute(ATTR_AUTHOR_AFFILIATION);
    }

    public String getAuthorLocation() {
        return this.getAttribute(ATTR_AUTHOR_LOCATION);
    }

    public Uri getAuthorPhoto() {
        return this.getUriAttribute(ATTR_AUTHOR_PHOTO);
    }

    public String getAuthorAboutme() {
        return this.getAttribute(ATTR_AUTHOR_ABOUTME);
    }

    public String getAuthorQuote() {
        return this.getAttribute(ATTR_AUTHOR_QUOTE);
    }

    public Uri getAuthorLink() {
        return this.getUriAttribute(ATTR_AUTHOR_LINK);
    }

    public boolean getShowStats() {
        return this.getBoolAttribute(ATTR_SHOW_STATS);
    }

    public boolean getShowInDirectory() {
        return this.getBoolAttribute(ATTR_SHOW_IN_DIRECTORY);
    }

    public boolean getSingleton() {
        return this.getBoolAttribute(ATTR_SINGLETON);
    }

    public boolean getScaling() {
        return this.getBoolAttribute(ATTR_SCALING);
    }

    public boolean getScrolling() {
        return this.getBoolAttribute(ATTR_SCROLLING);
    }

    public int getWidth() {
        return this.getIntAttribute(ATTR_WIDTH);
    }

    public int getHeight() {
        return this.getIntAttribute(ATTR_HEIGHT);
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String getAttribute(String name, String defaultValue) {
        String value = this.getAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Uri getUriAttribute(String name) {
        String uriAttribute = this.getAttribute(name);
        if (uriAttribute != null) {
            try {
                Uri uri = Uri.parse((String)uriAttribute);
                return this.base.resolve(uri);
            }
            catch (IllegalArgumentException e) {
                return EMPTY_URI;
            }
        }
        return EMPTY_URI;
    }

    public boolean getBoolAttribute(String name) {
        String value = this.getAttribute(name);
        return value != null && !"false".equals(value);
    }

    public int getIntAttribute(String name) {
        String value = this.getAttribute(name);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public Map<String, Feature> getFeatures() {
        return this.features;
    }

    public List<Preload> getPreloads() {
        return this.preloads;
    }

    public List<Icon> getIcons() {
        return this.icons;
    }

    public Map<Locale, LocaleSpec> getLocales() {
        return this.locales;
    }

    public Map<String, LinkSpec> getLinks() {
        return this.links;
    }

    public OAuthSpec getOAuthSpec() {
        return this.oauth;
    }

    public LocaleSpec getLocale(Locale locale) {
        if (this.locales.isEmpty()) {
            return null;
        }
        LocaleSpec localeSpec = this.locales.get(locale);
        if (localeSpec == null && (localeSpec = this.locales.get(locale = new Locale(locale.getLanguage(), "ALL"))) == null) {
            localeSpec = this.locales.get(GadgetSpec.DEFAULT_LOCALE);
        }
        return localeSpec;
    }

    public ModulePrefs substitute(Substitutions substituter) {
        return new ModulePrefs(this, substituter);
    }

    private static void walk(Element element, Map<String, ElementVisitor> visitors) throws SpecParserException {
        NodeList children = element.getChildNodes();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Node child = children.item(i);
            ElementVisitor visitor = visitors.get(child.getNodeName());
            if (visitor == null) continue;
            visitor.visit((Element)child);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<ModulePrefs");
        for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
            buf.append(' ').append(attr.getKey()).append("=\"").append(attr.getValue()).append('\"');
        }
        buf.append(">\n");
        for (Preload preload : this.preloads) {
            buf.append(preload).append('\n');
        }
        for (Feature feature : this.features.values()) {
            buf.append(feature).append('\n');
        }
        for (Icon icon : this.icons) {
            buf.append(icon).append('\n');
        }
        for (LocaleSpec locale : this.locales.values()) {
            buf.append(locale).append('\n');
        }
        for (LinkSpec link : this.links.values()) {
            buf.append(link).append('\n');
        }
        if (this.oauth != null) {
            buf.append(this.oauth).append('\n');
        }
        buf.append("</ModulePrefs>");
        return buf.toString();
    }

    private class LinkVisitor
    implements ElementVisitor {
        private final Map<String, LinkSpec> linkMap = Maps.newHashMap();

        private LinkVisitor() {
        }

        public void visit(Element element) throws SpecParserException {
            LinkSpec link = new LinkSpec(element, ModulePrefs.this.base);
            this.linkMap.put(link.getRel(), link);
        }
    }

    private class LocaleVisitor
    implements ElementVisitor {
        private final Map<Locale, LocaleSpec> localeMap = Maps.newHashMap();

        private LocaleVisitor() {
        }

        public void visit(Element element) throws SpecParserException {
            LocaleSpec locale = new LocaleSpec(element, ModulePrefs.this.base);
            this.localeMap.put(new Locale(locale.getLanguage(), locale.getCountry()), locale);
        }
    }

    private static class IconVisitor
    implements ElementVisitor {
        private final List<Icon> icons = Lists.newLinkedList();

        private IconVisitor() {
        }

        public void visit(Element element) throws SpecParserException {
            this.icons.add(new Icon(element));
        }
    }

    private static class FeatureVisitor
    implements ElementVisitor {
        private final Map<String, Feature> features = Maps.newHashMap();

        private FeatureVisitor() {
        }

        public void visit(Element element) throws SpecParserException {
            Feature feature = new Feature(element);
            this.features.put(feature.getName(), feature);
        }
    }

    private class OAuthVisitor
    implements ElementVisitor {
        private OAuthSpec oauthSpec = null;

        public void visit(Element element) throws SpecParserException {
            if (this.oauthSpec != null) {
                throw new SpecParserException("ModulePrefs/OAuth may only occur once.");
            }
            this.oauthSpec = new OAuthSpec(element, ModulePrefs.this.base);
        }
    }

    private class PreloadVisitor
    implements ElementVisitor {
        private final List<Preload> preloaded = Lists.newLinkedList();

        private PreloadVisitor() {
        }

        public void visit(Element element) throws SpecParserException {
            Preload preload = new Preload(element, ModulePrefs.this.base);
            this.preloaded.add(preload);
        }
    }

    static interface ElementVisitor {
        public void visit(Element var1) throws SpecParserException;
    }
}

