/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import com.google.inject.Inject;
import java.net.URI;
import java.net.URISyntaxException;
import net.oauth.OAuthServiceProvider;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.oauth.AccessorInfo;
import org.apache.shindig.gadgets.oauth.AccessorInfoBuilder;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.oauth.OAuthClientState;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.apache.shindig.gadgets.oauth.UserVisibleOAuthException;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.OAuthService;
import org.apache.shindig.gadgets.spec.OAuthSpec;

public class GadgetOAuthTokenStore {
    private final OAuthStore store;
    private final GadgetSpecFactory specFactory;

    @Inject
    public GadgetOAuthTokenStore(OAuthStore store, GadgetSpecFactory specFactory) {
        this.store = store;
        this.specFactory = specFactory;
    }

    public AccessorInfo getOAuthAccessor(SecurityToken securityToken, OAuthArguments arguments, OAuthClientState clientState) throws GadgetException {
        AccessorInfoBuilder accessorBuilder = new AccessorInfoBuilder();
        OAuthServiceProvider provider = null;
        if (arguments.mayUseToken()) {
            provider = this.lookupSpecInfo(securityToken, arguments, accessorBuilder);
        } else {
            accessorBuilder.setParameterLocation(AccessorInfo.OAuthParamLocation.URI_QUERY);
        }
        OAuthStore.ConsumerInfo consumer = this.store.getConsumerKeyAndSecret(securityToken, arguments.getServiceName(), provider);
        accessorBuilder.setConsumer(consumer);
        if (arguments.mayUseToken() && securityToken.getOwnerId() != null && securityToken.getViewerId().equals(securityToken.getOwnerId())) {
            this.lookupToken(securityToken, consumer, arguments, clientState, accessorBuilder);
        }
        return accessorBuilder.create();
    }

    private OAuthServiceProvider lookupSpecInfo(SecurityToken securityToken, OAuthArguments arguments, AccessorInfoBuilder accessorBuilder) throws GadgetException {
        GadgetSpec spec = this.findSpec(securityToken, arguments);
        OAuthSpec oauthSpec = spec.getModulePrefs().getOAuthSpec();
        if (oauthSpec == null) {
            throw this.oauthNotFoundEx(securityToken);
        }
        OAuthService service = oauthSpec.getServices().get(arguments.getServiceName());
        if (service == null) {
            throw this.serviceNotFoundEx(securityToken, oauthSpec, arguments.getServiceName());
        }
        accessorBuilder.setParameterLocation(this.getStoreLocation(service.getRequestUrl().location));
        accessorBuilder.setMethod(this.getStoreMethod(service.getRequestUrl().method));
        OAuthServiceProvider provider = new OAuthServiceProvider(service.getRequestUrl().url.toJavaUri().toASCIIString(), service.getAuthorizationUrl().toJavaUri().toASCIIString(), service.getAccessUrl().url.toJavaUri().toASCIIString());
        return provider;
    }

    private void lookupToken(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, OAuthArguments arguments, OAuthClientState clientState, AccessorInfoBuilder accessorBuilder) throws GadgetException {
        if (clientState.getRequestToken() != null) {
            accessorBuilder.setRequestToken(clientState.getRequestToken());
            accessorBuilder.setTokenSecret(clientState.getRequestTokenSecret());
        } else if (clientState.getAccessToken() != null) {
            accessorBuilder.setAccessToken(clientState.getAccessToken());
            accessorBuilder.setTokenSecret(clientState.getAccessTokenSecret());
            accessorBuilder.setSessionHandle(clientState.getSessionHandle());
            accessorBuilder.setTokenExpireMillis(clientState.getTokenExpireMillis());
        } else {
            OAuthStore.TokenInfo tokenInfo = this.store.getTokenInfo(securityToken, consumerInfo, arguments.getServiceName(), arguments.getTokenName());
            if (tokenInfo != null && tokenInfo.getAccessToken() != null) {
                accessorBuilder.setAccessToken(tokenInfo.getAccessToken());
                accessorBuilder.setTokenSecret(tokenInfo.getTokenSecret());
                accessorBuilder.setSessionHandle(tokenInfo.getSessionHandle());
                accessorBuilder.setTokenExpireMillis(tokenInfo.getTokenExpireMillis());
            } else {
                accessorBuilder.setRequestToken(arguments.getRequestToken());
                accessorBuilder.setTokenSecret(arguments.getRequestTokenSecret());
            }
        }
    }

    private AccessorInfo.OAuthParamLocation getStoreLocation(OAuthService.Location location) throws GadgetException {
        switch (location) {
            case HEADER: {
                return AccessorInfo.OAuthParamLocation.AUTH_HEADER;
            }
            case URL: {
                return AccessorInfo.OAuthParamLocation.URI_QUERY;
            }
            case BODY: {
                return AccessorInfo.OAuthParamLocation.POST_BODY;
            }
        }
        throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, "Unknown parameter location " + (Object)((Object)location));
    }

    private AccessorInfo.HttpMethod getStoreMethod(OAuthService.Method method) throws GadgetException {
        switch (method) {
            case GET: {
                return AccessorInfo.HttpMethod.GET;
            }
            case POST: {
                return AccessorInfo.HttpMethod.POST;
            }
        }
        throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, "Unknown method " + (Object)((Object)method));
    }

    private GadgetSpec findSpec(SecurityToken securityToken, OAuthArguments arguments) throws GadgetException {
        try {
            return this.specFactory.getGadgetSpec(new URI(securityToken.getAppUrl()), arguments.getBypassSpecCache());
        }
        catch (URISyntaxException e) {
            throw new UserVisibleOAuthException("could not fetch gadget spec, gadget URI invalid", (Throwable)e);
        }
    }

    private GadgetException serviceNotFoundEx(SecurityToken securityToken, OAuthSpec oauthSpec, String serviceName) {
        StringBuilder message = new StringBuilder().append("Spec for gadget ").append(securityToken.getAppUrl()).append(" does not contain OAuth service ").append(serviceName).append(".  Known services: ").append(StringUtils.join(oauthSpec.getServices().keySet(), (char)','));
        return new UserVisibleOAuthException(message.toString());
    }

    private GadgetException oauthNotFoundEx(SecurityToken securityToken) {
        StringBuilder message = new StringBuilder().append("Spec for gadget ").append(securityToken.getAppUrl()).append(" does not contain OAuth element.");
        return new UserVisibleOAuthException(message.toString());
    }

    public void storeTokenKeyAndSecret(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, OAuthArguments arguments, OAuthStore.TokenInfo tokenInfo) throws GadgetException {
        this.store.setTokenInfo(securityToken, consumerInfo, arguments.getServiceName(), arguments.getTokenName(), tokenInfo);
    }

    public void removeToken(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, OAuthArguments arguments) throws GadgetException {
        this.store.removeToken(securityToken, consumerInfo, arguments.getServiceName(), arguments.getTokenName());
    }
}

