/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.LruCacheProvider;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.TimeSource;
import org.apache.shindig.gadgets.DefaultMessageBundleFactory;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.MessageBundle;
import org.easymock.classextension.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DefaultMessageBundleFactoryTest {
    private static final Uri BUNDLE_URI = Uri.parse((String)"http://example.org/messagex.xml");
    private static final Uri SPEC_URI = Uri.parse((String)"http://example.org/gadget.xml");
    private static final String MSG_0_NAME = "messageZero";
    private static final String MSG_1_NAME = "message1";
    private static final String MSG_2_NAME = "message 2";
    private static final String MSG_0_VALUE = "Message 0 VALUE";
    private static final String MSG_0_ALT_VALUE = "Message 0 Alternative VALUE";
    private static final String MSG_1_VALUE = "msg one val";
    private static final String MSG_2_VALUE = "message two val.";
    private static final Locale PARENT_LOCALE = new Locale("en", "ALL");
    private static final Locale LOCALE = new Locale("en", "US");
    private static final String BASIC_BUNDLE = "<messagebundle>  <msg name='messageZero'>Message 0 VALUE</msg>  <msg name='message1'>msg one val</msg></messagebundle>";
    private static final String BASIC_SPEC = "<Module><ModulePrefs title='foo'> <Locale lang='all' country='ALL'>  <msg name='messageZero'>Message 0 VALUE</msg> </Locale> <Locale lang='" + LOCALE.getLanguage() + "'>" + "  <msg name='" + "messageZero" + "'>" + "Message 0 Alternative VALUE" + "</msg>" + "  <msg name='" + "message1" + "'>" + "msg one val" + "</msg>" + "  <msg name='" + "message 2" + "'>" + "message two val." + "</msg>" + " </Locale>" + " <Locale lang='" + LOCALE.getLanguage() + "' country='" + LOCALE.getCountry() + "' " + "  messages='" + BUNDLE_URI + "'/>" + "</ModulePrefs>" + "<Content type='html'/>" + "</Module>";
    private static final int MAX_AGE = 10000;
    private final HttpFetcher fetcher = (HttpFetcher)org.easymock.EasyMock.createNiceMock(HttpFetcher.class);
    private final CacheProvider cacheProvider = new LruCacheProvider(10);
    private final Cache<String, MessageBundle> cache = this.cacheProvider.createCache("messageBundles");
    private final DefaultMessageBundleFactory bundleFactory = new DefaultMessageBundleFactory(this.fetcher, this.cacheProvider, 10000L);
    private final GadgetSpec gadgetSpec;

    public DefaultMessageBundleFactoryTest() {
        try {
            this.gadgetSpec = new GadgetSpec(SPEC_URI, BASIC_SPEC);
        }
        catch (GadgetException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void getBundle() throws Exception {
        HttpResponse response = new HttpResponse(BASIC_BUNDLE);
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch((HttpRequest)org.easymock.EasyMock.isA(HttpRequest.class))).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.fetcher});
        MessageBundle bundle = this.bundleFactory.getBundle(this.gadgetSpec, LOCALE, true);
        Assert.assertEquals((Object)MSG_0_VALUE, bundle.getMessages().get(MSG_0_NAME));
        Assert.assertEquals((Object)MSG_1_VALUE, bundle.getMessages().get(MSG_1_NAME));
        Assert.assertEquals((Object)MSG_2_VALUE, bundle.getMessages().get(MSG_2_NAME));
    }

    @Test
    public void getBundleFromCache() throws Exception {
        HttpResponse response = new HttpResponse(BASIC_BUNDLE);
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch((HttpRequest)org.easymock.EasyMock.isA(HttpRequest.class))).andReturn((Object)response).once();
        EasyMock.replay((Object[])new Object[]{this.fetcher});
        MessageBundle bundle0 = this.bundleFactory.getBundle(this.gadgetSpec, LOCALE, false);
        MessageBundle bundle1 = this.bundleFactory.getBundle(this.gadgetSpec, LOCALE, false);
        Assert.assertSame((String)"Different objects returned out of the cache", (Object)bundle0, (Object)bundle1);
    }

    @Test
    public void getParentBundle() throws Exception {
        MessageBundle bundle = this.bundleFactory.getBundle(this.gadgetSpec, PARENT_LOCALE, true);
        Assert.assertEquals((Object)MSG_0_ALT_VALUE, bundle.getMessages().get(MSG_0_NAME));
        Assert.assertEquals((Object)MSG_1_VALUE, bundle.getMessages().get(MSG_1_NAME));
        Assert.assertEquals((Object)MSG_2_VALUE, bundle.getMessages().get(MSG_2_NAME));
    }

    @Test
    public void getAllAllBundle() throws Exception {
        MessageBundle bundle = this.bundleFactory.getBundle(this.gadgetSpec, new Locale("all", "ALL"), true);
        Assert.assertEquals((Object)MSG_0_VALUE, bundle.getMessages().get(MSG_0_NAME));
    }

    @Test
    public void ignoreCacheDoesNotStore() throws Exception {
        this.bundleFactory.getBundle(this.gadgetSpec, new Locale("all", "ALL"), true);
        Assert.assertEquals((long)0L, (long)this.cache.getSize());
    }

    @Test
    public void badResponseServedFromCache() throws Exception {
        HttpResponse expiredResponse = new HttpResponseBuilder().setResponse(BASIC_BUNDLE.getBytes("UTF-8")).addHeader("Pragma", "no-cache").create();
        HttpResponse badResponse = HttpResponse.error();
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch((HttpRequest)org.easymock.EasyMock.isA(HttpRequest.class))).andReturn((Object)expiredResponse).once();
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch((HttpRequest)org.easymock.EasyMock.isA(HttpRequest.class))).andReturn((Object)badResponse).once();
        EasyMock.replay((Object[])new Object[]{this.fetcher});
        final AtomicLong time = new AtomicLong();
        this.bundleFactory.cache.setTimeSource(new TimeSource(){

            public long currentTimeMillis() {
                return time.get();
            }
        });
        time.set(System.currentTimeMillis());
        MessageBundle bundle0 = this.bundleFactory.getBundle(this.gadgetSpec, LOCALE, false);
        time.set(time.get() + 10000L + 1L);
        MessageBundle bundle1 = this.bundleFactory.getBundle(this.gadgetSpec, LOCALE, false);
        org.easymock.EasyMock.verify((Object[])new Object[]{this.fetcher});
        Assert.assertSame((String)"Did not respond from cache when refresh failed.", (Object)bundle0, (Object)bundle1);
    }

    @Test
    public void badResponseIsEmptyWhenNotInCache() throws Exception {
        HttpResponse badResponse = HttpResponse.error();
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch((HttpRequest)org.easymock.EasyMock.isA(HttpRequest.class))).andReturn((Object)badResponse).once();
        EasyMock.replay((Object[])new Object[]{this.fetcher});
        MessageBundle bundle = this.bundleFactory.getBundle(this.gadgetSpec, LOCALE, false);
        org.easymock.EasyMock.verify((Object[])new Object[]{this.fetcher});
        Assert.assertEquals((long)0L, (long)bundle.getMessages().size());
    }

    @Test
    public void ttlPropagatesToFetcher() throws Exception {
        CapturingFetcher capturingFetcher = new CapturingFetcher();
        DefaultMessageBundleFactory factory = new DefaultMessageBundleFactory((HttpFetcher)capturingFetcher, this.cacheProvider, 10000L);
        factory.getBundle(this.gadgetSpec, LOCALE, false);
        Assert.assertEquals((long)10L, (long)capturingFetcher.request.getCacheTtl());
    }

    private static class CapturingFetcher
    implements HttpFetcher {
        HttpRequest request;

        private CapturingFetcher() {
        }

        public HttpResponse fetch(HttpRequest request) {
            this.request = request;
            return new HttpResponse(DefaultMessageBundleFactoryTest.BASIC_BUNDLE);
        }
    }
}

