/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.junit.Assert;
import org.junit.Test;

public class GadgetTest {
    private static final String SPEC_URL = "http://example.org/gadget.xml";
    private static final String SPEC_XML = "<Module><ModulePrefs title='title'>  <Preload href='http://example.org/foo'/>  <Locale>    <msg name='name'>VALUE</msg>  </Locale></ModulePrefs><Content type='html'>DEFAULT VIEW</Content><Content view='one' type='html'>VIEW ONE</Content><Content view='two' type='html'>VIEW TWO</Content></Module>";
    private final DummyContext context = new DummyContext();

    @Test
    public void getLocale() throws Exception {
        Gadget gadget = new Gadget().setContext((GadgetContext)this.context).setSpec(new GadgetSpec(Uri.parse((String)SPEC_URL), SPEC_XML));
        LocaleSpec localeSpec = gadget.getLocale();
        Assert.assertEquals((Object)"VALUE", localeSpec.getMessageBundle().getMessages().get("name"));
    }

    private static class DummyContext
    extends GadgetContext {
        public String view = super.getView();
        public String container = super.getContainer();

        private DummyContext() {
        }

        public String getView() {
            return this.view;
        }

        public String getContainer() {
            return this.container;
        }
    }
}

