/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.encoding;

import org.apache.shindig.gadgets.encoding.EncodingDetector;
import org.junit.Assert;
import org.junit.Test;

public class EncodingDetectorTest {
    @Test
    public void asciiAssumesUtf8() throws Exception {
        byte[] data = "Hello, world".getBytes("US-ASCII");
        Assert.assertEquals((Object)"UTF-8", (Object)EncodingDetector.detectEncoding((byte[])data, (boolean)true));
    }

    @Test
    public void detectedUtf8WithByteOrderMark() {
        byte[] data = new byte[]{-17, -69, -65, 104, 101, 108, 108, 111};
        Assert.assertEquals((Object)"UTF-8", (Object)EncodingDetector.detectEncoding((byte[])data, (boolean)true));
    }

    @Test
    public void assumeLatin1OnInvalidUtf8() throws Exception {
        byte[] data = "\u4f60\u597d".getBytes("BIG5");
        Assert.assertEquals((Object)"ISO-8859-1", (Object)EncodingDetector.detectEncoding((byte[])data, (boolean)true));
    }

    @Test
    public void doNotAssumeLatin1OnInvalidUtf8() throws Exception {
        byte[] data = "\u6211\u662f\u4e00\u4e2a\u4e0d\u5584\u4e8e\u8bb2\u8bdd\u7684\u4eba\uff0c\u552f\u5176\u4e0d\u5584\u4e8e\u8bb2\u8bdd\uff0c\u6709\u601d\u60f3\u8868\u8fbe\u4e0d\u51fa\uff0c\u6709\u611f\u60c5\u65e0\u6cd5\u503e\u5410".getBytes("GB18030");
        Assert.assertEquals((Object)"GB18030", (Object)EncodingDetector.detectEncoding((byte[])data, (boolean)false));
    }

    @Test
    public void longUtf8StringIsUtf8() throws Exception {
        byte[] data = "\u6211\u662f\u4e00\u4e2a\u4e0d\u5584\u4e8e\u8bb2\u8bdd\u7684\u4eba\uff0c\u552f\u5176\u4e0d\u5584\u4e8e\u8bb2\u8bdd\uff0c\u6709\u601d\u60f3\u8868\u8fbe\u4e0d\u51fa\uff0c\u6709\u611f\u60c5\u65e0\u6cd5\u503e\u5410".getBytes("UTF-8");
        Assert.assertEquals((Object)"UTF-8", (Object)EncodingDetector.detectEncoding((byte[])data, (boolean)true));
    }

    @Test
    public void shortUtf8StringIsUtf8() throws Exception {
        byte[] data = "Games, HQ, Mang\u00e1, Anime e tudo que um bom nerd ama".getBytes("UTF-8");
        Assert.assertEquals((Object)"UTF-8", (Object)EncodingDetector.detectEncoding((byte[])data, (boolean)true));
    }
}

