/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.Maps;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.shindig.gadgets.http.AbstractHttpCache;
import org.apache.shindig.gadgets.http.HttpCacheKey;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.easymock.classextension.EasyMock;

public class AbstractHttpCacheTest
extends TestCase {
    public void testCache() {
        HttpCacheKey key = (HttpCacheKey)EasyMock.createNiceMock(HttpCacheKey.class);
        org.easymock.EasyMock.expect((Object)key.isCacheable()).andReturn((Object)true).anyTimes();
        HttpRequest request = (HttpRequest)EasyMock.createNiceMock(HttpRequest.class);
        org.easymock.EasyMock.expect((Object)request.getIgnoreCache()).andReturn((Object)false).anyTimes();
        org.easymock.EasyMock.expect((Object)request.getCacheTtl()).andReturn((Object)Integer.MAX_VALUE).anyTimes();
        EasyMock.replay((Object[])new Object[]{key, request});
        HttpResponse response = new HttpResponseBuilder().setHttpStatusCode(200).setResponse("foo".getBytes()).setCacheTtl(Integer.MAX_VALUE).create();
        TestHttpCache ahc = new TestHttpCache();
        HttpResponse added = ahc.addResponse(key, request, response);
        AbstractHttpCacheTest.assertNotSame((Object)added, (Object)response);
        AbstractHttpCacheTest.assertEquals((String)"foo", (String)added.getResponseAsString());
        AbstractHttpCacheTest.assertSame((Object)added, (Object)ahc.getResponse(key, request));
        AbstractHttpCacheTest.assertEquals((Object)response, (Object)ahc.removeResponse(key));
    }

    private static class TestHttpCache
    extends AbstractHttpCache {
        private final Map<String, HttpResponse> map = Maps.newHashMap();

        public void addResponseImpl(String key, HttpResponse response) {
            this.map.put(key, response);
        }

        public HttpResponse getResponseImpl(String key) {
            return this.map.get(key);
        }

        public HttpResponse removeResponseImpl(String key) {
            return this.map.remove(key);
        }
    }
}

