/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.process;

import java.net.URI;
import java.util.Arrays;
import org.apache.shindig.common.ContainerConfig;
import org.apache.shindig.common.ContainerConfigException;
import org.apache.shindig.common.JsonContainerConfig;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetBlacklist;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.variables.VariableSubstituter;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProcessorTest {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/gadget.xml");
    private static final Uri TYPE_URL_HREF = Uri.parse((String)"http://example.org/gadget.php");
    private static final String BASIC_HTML_CONTENT = "Hello, World!";
    private static final String GADGET = "<Module> <ModulePrefs title='foo'/> <Content view='html' type='html'>Hello, World!</Content> <Content view='url' type='url' href='" + TYPE_URL_HREF + "'/>" + " <Content view='alias' type='html'>" + "Hello, World!" + "</Content>" + "</Module>";
    private final FakeGadgetSpecFactory gadgetSpecFactory = new FakeGadgetSpecFactory();
    private final FakeVariableSubstituter substituter = new FakeVariableSubstituter();
    private final FakeBlacklist blacklist = new FakeBlacklist();
    private FakeContainerConfig containerConfig;
    private Processor processor;

    @Before
    public void setUp() throws Exception {
        this.containerConfig = new FakeContainerConfig();
        this.processor = new Processor((GadgetSpecFactory)this.gadgetSpecFactory, (VariableSubstituter)this.substituter, (ContainerConfig)this.containerConfig, (GadgetBlacklist)this.blacklist);
    }

    private GadgetContext makeContext(final String view, final Uri specUrl) {
        return new GadgetContext(){

            public URI getUrl() {
                if (specUrl == null) {
                    return null;
                }
                return specUrl.toJavaUri();
            }

            public String getView() {
                return view;
            }
        };
    }

    private GadgetContext makeContext(String view) {
        return this.makeContext(view, SPEC_URL);
    }

    @Test
    public void normalProcessing() throws Exception {
        Gadget gadget = this.processor.process(this.makeContext("html"));
        Assert.assertEquals((Object)BASIC_HTML_CONTENT, (Object)gadget.getCurrentView().getContent());
    }

    @Test(expected=ProcessingException.class)
    public void handlesGadgetExceptionGracefully() throws Exception {
        this.gadgetSpecFactory.exception = new GadgetException(GadgetException.Code.INVALID_PATH);
        this.processor.process(this.makeContext("url"));
    }

    @Test
    public void doViewAliasing() throws Exception {
        JSONArray aliases = new JSONArray(Arrays.asList("some-alias", "alias"));
        this.containerConfig.json.put("gadgets.features/views/aliased/aliases", (Object)aliases);
        Gadget gadget = this.processor.process(this.makeContext("aliased"));
        Assert.assertEquals((Object)BASIC_HTML_CONTENT, (Object)gadget.getCurrentView().getContent());
    }

    @Test
    public void noSupportedViewHasNoCurrentView() throws Exception {
        Gadget gadget = this.processor.process(this.makeContext("not-real-view"));
        Assert.assertNull((Object)gadget.getCurrentView());
    }

    @Test
    public void substitutionsPerformedTypeHtml() throws Exception {
        this.processor.process(this.makeContext("html"));
        Assert.assertTrue((String)"Substitutions not performed", (boolean)this.substituter.wasSubstituted);
    }

    @Test
    public void substitutionsPerformedTypeUrl() throws Exception {
        this.processor.process(this.makeContext("url"));
        Assert.assertTrue((String)"Substitutions not performed", (boolean)this.substituter.wasSubstituted);
    }

    @Test
    public void blacklistChecked() throws Exception {
        this.processor.process(this.makeContext("url"));
        Assert.assertTrue((String)"Blacklist not checked", (boolean)this.blacklist.wasChecked);
    }

    @Test(expected=ProcessingException.class)
    public void blacklistedGadgetThrows() throws Exception {
        this.blacklist.isBlacklisted = true;
        this.processor.process(this.makeContext("html"));
    }

    @Test(expected=ProcessingException.class)
    public void nullUrlThrows() throws ProcessingException {
        this.processor.process(this.makeContext("html", null));
    }

    @Test(expected=ProcessingException.class)
    public void nonHttpOrHttpsThrows() throws ProcessingException {
        this.processor.process(this.makeContext("html", Uri.parse((String)"file://foo")));
    }

    private static class FakeVariableSubstituter
    extends VariableSubstituter {
        private boolean wasSubstituted;

        public FakeVariableSubstituter() {
            super(null);
        }

        public GadgetSpec substitute(GadgetContext context, GadgetSpec spec) {
            this.wasSubstituted = true;
            return spec;
        }
    }

    private static class FakeGadgetSpecFactory
    implements GadgetSpecFactory {
        private GadgetException exception;

        private FakeGadgetSpecFactory() {
        }

        public GadgetSpec getGadgetSpec(GadgetContext context) throws GadgetException {
            if (this.exception != null) {
                throw this.exception;
            }
            return new GadgetSpec(Uri.fromJavaUri((URI)context.getUrl()), GADGET);
        }

        public GadgetSpec getGadgetSpec(URI uri, boolean ignoreCache) {
            throw new UnsupportedOperationException();
        }
    }

    private static class FakeContainerConfig
    extends JsonContainerConfig {
        private final JSONObject json = new JSONObject();

        public FakeContainerConfig() throws ContainerConfigException {
            super(null);
        }

        public Object getJson(String container, String parameter) {
            return this.json.opt(parameter);
        }
    }

    private static class FakeBlacklist
    implements GadgetBlacklist {
        private boolean wasChecked;
        private boolean isBlacklisted;

        private FakeBlacklist() {
        }

        public boolean isBlacklisted(URI gadgetUri) {
            this.wasChecked = true;
            return this.isBlacklisted;
        }
    }
}

