/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.ContentFetcherFactory;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.preload.PreloaderService;
import org.apache.shindig.gadgets.preload.Preloads;
import org.apache.shindig.gadgets.render.HtmlRenderer;
import org.apache.shindig.gadgets.rewrite.ContentRewriterRegistry;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.View;
import org.junit.Assert;
import org.junit.Test;

public class HtmlRendererTest {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/gadget.xml");
    private static final String BASIC_HTML_CONTENT = "Hello, World!";
    private static final String PROXIED_HTML_CONTENT = "Hello, Universe!";
    private static final Uri PROXIED_HTML_HREF = Uri.parse((String)"http://example.org/proxied.php");
    private static final Uri EXPECTED_PROXIED_HTML_HREF = Uri.parse((String)"http://example.org/proxied.php?lang=all&country=ALL");
    private static final GadgetContext CONTEXT = new GadgetContext(){

        public SecurityToken getToken() {
            return new AnonymousSecurityToken();
        }
    };
    private final FakeContentFetcherFactory fetcher = new FakeContentFetcherFactory();
    private final FakePreloaderService preloaderService = new FakePreloaderService();
    private final FakeContentRewriterRegistry rewriter = new FakeContentRewriterRegistry();
    private final HtmlRenderer renderer = new HtmlRenderer((ContentFetcherFactory)this.fetcher, (PreloaderService)this.preloaderService, (ContentRewriterRegistry)this.rewriter);

    private Gadget makeGadget(String content) throws GadgetException {
        GadgetSpec spec = new GadgetSpec(SPEC_URL, "<Module><ModulePrefs title=''/><Content><![CDATA[" + content + "]]></Content></Module>");
        return new Gadget().setSpec(spec).setContext(CONTEXT).setCurrentView(spec.getView("default"));
    }

    private Gadget makeHrefGadget(String authz) throws Exception {
        Gadget gadget = this.makeGadget("");
        String doc = "<Content href='" + PROXIED_HTML_HREF + "' authz='" + authz + "'/>";
        View view = new View("proxied", Arrays.asList(XmlUtil.parse((String)doc)), SPEC_URL);
        gadget.setCurrentView(view);
        return gadget;
    }

    @Test
    public void renderPlainTypeHtml() throws Exception {
        String content = this.renderer.render(this.makeGadget(BASIC_HTML_CONTENT));
        Assert.assertEquals((Object)BASIC_HTML_CONTENT, (Object)content);
    }

    @Test
    public void renderProxied() throws Exception {
        this.fetcher.plainResponses.put(EXPECTED_PROXIED_HTML_HREF, new HttpResponse(PROXIED_HTML_CONTENT));
        String content = this.renderer.render(this.makeHrefGadget("none"));
        Assert.assertEquals((Object)PROXIED_HTML_CONTENT, (Object)content);
    }

    @Test
    public void renderProxiedSigned() throws Exception {
        this.fetcher.signedResponses.put(EXPECTED_PROXIED_HTML_HREF, new HttpResponse(PROXIED_HTML_CONTENT));
        String content = this.renderer.render(this.makeHrefGadget("signed"));
        Assert.assertEquals((Object)PROXIED_HTML_CONTENT, (Object)content);
    }

    @Test
    public void renderProxiedOAuth() throws Exception {
        this.fetcher.oauthResponses.put(EXPECTED_PROXIED_HTML_HREF, new HttpResponse(PROXIED_HTML_CONTENT));
        String content = this.renderer.render(this.makeHrefGadget("oauth"));
        Assert.assertEquals((Object)PROXIED_HTML_CONTENT, (Object)content);
    }

    @Test
    public void renderProxiedCustomLocale() throws Exception {
        UriBuilder uri = new UriBuilder(PROXIED_HTML_HREF);
        uri.putQueryParameter("lang", new String[]{"foo"});
        uri.putQueryParameter("country", new String[]{"BAR"});
        Gadget gadget = this.makeHrefGadget("none");
        gadget.setContext(new GadgetContext(){

            public Locale getLocale() {
                return new Locale("foo", "BAR");
            }

            public SecurityToken getToken() {
                return new AnonymousSecurityToken();
            }
        });
        this.fetcher.plainResponses.put(uri.toUri(), new HttpResponse(PROXIED_HTML_CONTENT));
        String content = this.renderer.render(gadget);
        Assert.assertEquals((Object)PROXIED_HTML_CONTENT, (Object)content);
    }

    @Test
    public void doPreloading() throws Exception {
        this.renderer.render(this.makeGadget(BASIC_HTML_CONTENT));
        Assert.assertTrue((String)"Preloading not performed.", (boolean)this.preloaderService.wasPreloaded);
    }

    @Test
    public void doRewriting() throws Exception {
        this.renderer.render(this.makeGadget(BASIC_HTML_CONTENT));
        Assert.assertTrue((String)"Rewriting not performed.", (boolean)this.rewriter.wasRewritten);
    }

    private static class FakeContentRewriterRegistry
    implements ContentRewriterRegistry {
        private boolean wasRewritten = false;

        private FakeContentRewriterRegistry() {
        }

        public String rewriteGadget(Gadget gadget, View currentView) throws GadgetException {
            throw new UnsupportedOperationException();
        }

        public String rewriteGadget(Gadget gadget, String content) {
            this.wasRewritten = true;
            return content;
        }

        public HttpResponse rewriteHttpResponse(HttpRequest req, HttpResponse resp) {
            throw new UnsupportedOperationException();
        }
    }

    private static class FakePreloaderService
    implements PreloaderService {
        private boolean wasPreloaded;

        private FakePreloaderService() {
        }

        public Preloads preload(GadgetContext context, GadgetSpec gadget) {
            this.wasPreloaded = true;
            return null;
        }
    }

    private static class FakeContentFetcherFactory
    extends ContentFetcherFactory {
        private final Map<Uri, HttpResponse> plainResponses = Maps.newHashMap();
        private final Map<Uri, HttpResponse> signedResponses = Maps.newHashMap();
        private final Map<Uri, HttpResponse> oauthResponses = Maps.newHashMap();

        public FakeContentFetcherFactory() {
            super(null, null);
        }

        public HttpResponse fetch(HttpRequest request) throws GadgetException {
            HttpResponse response;
            if (request.getGadget() == null) {
                throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "No gadget associated with rendering request.");
            }
            if (request.getContainer() == null) {
                throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "No container associated with rendering request.");
            }
            if (request.getSecurityToken() == null) {
                throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "No security token associated with rendering request.");
            }
            if (request.getOAuthArguments() == null) {
                throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "No oauth arguments associated with rendering request.");
            }
            switch (request.getAuthType()) {
                case NONE: {
                    response = this.plainResponses.get(request.getUri());
                    break;
                }
                case SIGNED: {
                    response = this.signedResponses.get(request.getUri());
                    break;
                }
                case OAUTH: {
                    response = this.oauthResponses.get(request.getUri());
                    break;
                }
                default: {
                    response = null;
                }
            }
            if (response == null) {
                throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "Unknown file: " + request.getUri());
            }
            return response;
        }
    }
}

