/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import java.util.Arrays;
import org.apache.shindig.common.ContainerConfig;
import org.apache.shindig.common.ContainerConfigException;
import org.apache.shindig.common.JsonContainerConfig;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.LockedDomainService;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.render.HtmlRenderer;
import org.apache.shindig.gadgets.render.Renderer;
import org.apache.shindig.gadgets.render.RenderingException;
import org.apache.shindig.gadgets.render.RenderingResults;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.View;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RendererTest {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/gadget.xml");
    private static final Uri TYPE_URL_HREF = Uri.parse((String)"http://example.org/gadget.php");
    private static final String BASIC_HTML_CONTENT = "Hello, World!";
    private static final String GADGET = "<Module> <ModulePrefs title='foo'/> <Content view='html' type='html'>Hello, World!</Content> <Content view='url' type='url' href='" + TYPE_URL_HREF + "'/>" + "</Module>";
    private final FakeHtmlRenderer htmlRenderer = new FakeHtmlRenderer();
    private final FakeProcessor processor = new FakeProcessor();
    private final FakeLockedDomainService lockedDomainService = new FakeLockedDomainService();
    private FakeContainerConfig containerConfig;
    private Renderer renderer;

    @Before
    public void setUp() throws Exception {
        this.containerConfig = new FakeContainerConfig();
        this.renderer = new Renderer((Processor)this.processor, (HtmlRenderer)this.htmlRenderer, (ContainerConfig)this.containerConfig, (LockedDomainService)this.lockedDomainService);
    }

    private GadgetContext makeContext(final String view) {
        return new GadgetContext(){

            public String getView() {
                return view;
            }

            public String getParameter(String name) {
                if (name.equals("parent")) {
                    return "http://example.org/foo";
                }
                return null;
            }
        };
    }

    @Test
    public void renderTypeHtml() {
        RenderingResults results = this.renderer.render(this.makeContext("html"));
        Assert.assertEquals((Object)RenderingResults.Status.OK, (Object)results.getStatus());
        Assert.assertEquals((Object)BASIC_HTML_CONTENT, (Object)results.getContent());
    }

    @Test
    public void renderTypeUrl() {
        RenderingResults results = this.renderer.render(this.makeContext("url"));
        Assert.assertEquals((Object)RenderingResults.Status.MUST_REDIRECT, (Object)results.getStatus());
        Assert.assertEquals((Object)TYPE_URL_HREF, (Object)results.getRedirect());
    }

    @Test
    public void handlesProcessingExceptionGracefully() {
        this.processor.exception = new ProcessingException("foo");
        RenderingResults results = this.renderer.render(this.makeContext("html"));
        Assert.assertEquals((Object)RenderingResults.Status.ERROR, (Object)results.getStatus());
        Assert.assertEquals((Object)"foo", (Object)results.getErrorMessage());
    }

    @Test
    public void handlesRenderingExceptionGracefully() {
        this.htmlRenderer.exception = new RenderingException("oh no!");
        RenderingResults results = this.renderer.render(this.makeContext("html"));
        Assert.assertEquals((Object)RenderingResults.Status.ERROR, (Object)results.getStatus());
        Assert.assertEquals((Object)"oh no!", (Object)results.getErrorMessage());
    }

    @Test
    public void handlesRuntimeWrappedGadgetExceptionGracefully() {
        this.htmlRenderer.runtimeException = new RuntimeException(new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "oh no!"));
        RenderingResults results = this.renderer.render(this.makeContext("html"));
        Assert.assertEquals((Object)RenderingResults.Status.ERROR, (Object)results.getStatus());
        Assert.assertEquals((Object)"oh no!", (Object)results.getErrorMessage());
    }

    @Test(expected=RuntimeException.class)
    public void otherRuntimeExceptionsThrow() {
        this.htmlRenderer.runtimeException = new RuntimeException("Help!");
        this.renderer.render(this.makeContext("html"));
    }

    @Test
    public void validateParent() throws Exception {
        this.containerConfig.json.put("gadgets.parent", (Object)new JSONArray(Arrays.asList("http:\\/\\/example\\.org\\/[a-z]+", "localhost")));
        RenderingResults results = this.renderer.render(this.makeContext("html"));
        Assert.assertEquals((Object)RenderingResults.Status.OK, (Object)results.getStatus());
    }

    @Test
    public void validateBadParent() throws Exception {
        this.containerConfig.json.put("gadgets.parent", (Object)new JSONArray(Arrays.asList("http:\\/\\/example\\.com\\/[a-z]+", "localhost")));
        RenderingResults results = this.renderer.render(this.makeContext("html"));
        Assert.assertEquals((Object)RenderingResults.Status.ERROR, (Object)results.getStatus());
        Assert.assertNotNull((String)"No error message provided for bad parent.", (Object)results.getErrorMessage());
    }

    @Test
    public void handlesNoCurrentViewGracefully() throws Exception {
        RenderingResults results = this.renderer.render(this.makeContext("bad-view-name"));
        Assert.assertEquals((Object)RenderingResults.Status.ERROR, (Object)results.getStatus());
        Assert.assertNotNull((String)"No error message for missing current view", (Object)results.getErrorMessage());
    }

    @Test
    public void verifyLockedDomain() throws Exception {
        this.renderer.render(this.makeContext("html"));
        Assert.assertTrue((String)"Locked domain not verified", (boolean)this.lockedDomainService.wasChecked);
    }

    @Test
    public void wrongDomainRedirects() throws Exception {
        this.lockedDomainService.canRender = false;
        RenderingResults results = this.renderer.render(this.makeContext("html"));
        Assert.assertEquals((Object)RenderingResults.Status.MUST_REDIRECT, (Object)results.getStatus());
        Assert.assertNull((Object)results.getRedirect());
    }

    private static class FakeLockedDomainService
    implements LockedDomainService {
        private boolean wasChecked = false;
        private boolean canRender = true;

        private FakeLockedDomainService() {
        }

        public boolean gadgetCanRender(String host, GadgetSpec gadget, String container) {
            this.wasChecked = true;
            return this.canRender;
        }

        public String getLockedDomainForGadget(GadgetSpec gadget, String container) {
            return null;
        }

        public boolean isSafeForOpenProxy(String host) {
            return false;
        }
    }

    private static class FakeProcessor
    extends Processor {
        private ProcessingException exception;

        public FakeProcessor() {
            super(null, null, null, null);
        }

        public Gadget process(GadgetContext context) throws ProcessingException {
            if (this.exception != null) {
                throw this.exception;
            }
            try {
                GadgetSpec spec = new GadgetSpec(SPEC_URL, GADGET);
                View view = spec.getView(context.getView());
                return new Gadget().setContext(context).setSpec(spec).setCurrentView(view);
            }
            catch (GadgetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class FakeHtmlRenderer
    extends HtmlRenderer {
        private RenderingException exception;
        private RuntimeException runtimeException;

        public FakeHtmlRenderer() {
            super(null, null, null);
        }

        public String render(Gadget gadget) throws RenderingException {
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.runtimeException != null) {
                throw this.runtimeException;
            }
            return gadget.getCurrentView().getContent();
        }
    }

    private static class FakeContainerConfig
    extends JsonContainerConfig {
        private final JSONObject json = new JSONObject();

        public FakeContainerConfig() throws ContainerConfigException {
            super(null);
        }

        public Object getJson(String container, String parameter) {
            return this.json.opt(parameter);
        }
    }
}

