/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.caja.util.Join;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shindig.common.ContainerConfig;
import org.apache.shindig.common.PropertiesModule;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.MessageBundleFactory;
import org.apache.shindig.gadgets.UrlGenerator;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.preload.NullPreloads;
import org.apache.shindig.gadgets.preload.PreloadException;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.preload.Preloads;
import org.apache.shindig.gadgets.render.RenderingContentRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.MessageBundle;
import org.apache.shindig.gadgets.spec.View;
import org.easymock.EasyMock;
import org.easymock.classextension.IMocksControl;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderingContentRewriterTest {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/gadget.xml");
    private static final String BODY_CONTENT = "Some body content";
    private final IMocksControl control = org.easymock.classextension.EasyMock.createNiceControl();
    private final FakeMessageBundleFactory messageBundleFactory = new FakeMessageBundleFactory();
    private final ContainerConfig config = (ContainerConfig)this.control.createMock(ContainerConfig.class);
    private final UrlGenerator urlGenerator = new FakeUrlGenerator();
    private FakeGadgetFeatureRegistry featureRegistry;
    private RenderingContentRewriter rewriter;
    private GadgetHtmlParser parser;
    static final Pattern DOCUMENT_SPLIT_PATTERN = Pattern.compile("(.*)<head>(.*?)<\\/head>(?:.*)<body(.*?)>(.*?)<\\/body>(?:.*)", 34);
    static final int BEFORE_HEAD_GROUP = 1;
    static final int HEAD_GROUP = 2;
    static final int BODY_ATTRIBUTES_GROUP = 3;
    static final int BODY_GROUP = 4;

    @Before
    public void setUp() throws Exception {
        this.featureRegistry = new FakeGadgetFeatureRegistry();
        this.rewriter = new RenderingContentRewriter((MessageBundleFactory)this.messageBundleFactory, this.config, (GadgetFeatureRegistry)this.featureRegistry, this.urlGenerator);
        Injector injector = Guice.createInjector((Module[])new Module[]{new ParseModule(), new PropertiesModule()});
        this.parser = (GadgetHtmlParser)injector.getInstance(GadgetHtmlParser.class);
    }

    private Gadget makeGadgetWithSpec(String gadgetXml) throws GadgetException {
        GadgetSpec spec = new GadgetSpec(SPEC_URL, gadgetXml);
        return new Gadget().setContext(new GadgetContext()).setPreloads((Preloads)new NullPreloads()).setSpec(spec);
    }

    private Gadget makeDefaultGadget() throws GadgetException {
        String defaultXml = "<Module><ModulePrefs title=''/><Content type='html'/></Module>";
        return this.makeGadgetWithSpec(defaultXml);
    }

    private String rewrite(Gadget gadget, String content) {
        MutableContent mc = new MutableContent(this.parser, content);
        Assert.assertEquals((long)0L, (long)this.rewriter.rewrite(gadget, mc).getCacheTtl());
        return mc.getContent();
    }

    @Test
    public void defaultOutput() throws Exception {
        Gadget gadget = this.makeDefaultGadget();
        this.control.replay();
        String rewritten = this.rewrite(gadget, BODY_CONTENT);
        Matcher matcher = DOCUMENT_SPLIT_PATTERN.matcher(rewritten);
        Assert.assertTrue((String)"Output is not valid HTML.", (boolean)matcher.matches());
        Assert.assertTrue((String)"Missing opening html tag", (boolean)matcher.group(1).toLowerCase().contains("<html>"));
        Assert.assertTrue((String)"Default CSS missing.", (boolean)matcher.group(2).contains("body,td,div,span,p{font-family:arial,sans-serif;}a {color:#0000cc;}a:visited {color:#551a8b;}a:active {color:#ff0000;}body{margin: 0px;padding: 0px;background-color:white;}"));
        Assert.assertTrue((String)"Default javascript not included.", (boolean)matcher.group(2).contains("<script>"));
        Assert.assertTrue((String)"Original document not preserved.", (boolean)matcher.group(4).contains(BODY_CONTENT));
        Assert.assertTrue((String)"gadgets.util.runOnLoadHandlers not invoked.", (boolean)matcher.group(4).contains("gadgets.util.runOnLoadHandlers();"));
    }

    @Test
    public void completeDocument() throws Exception {
        String docType = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">";
        String head = "<script src=\"foo.js\"></script><style type=\"text/css\">body{color:red;}</style>";
        String bodyAttr = " onload=\"foo();\"";
        String body = "hello, world.";
        String doc = docType + "<html><head>" + head + "</head><body" + bodyAttr + ">" + body + "</body></html>";
        GadgetContext context = new GadgetContext(){

            public String getParameter(String name) {
                if (name.equals("libs")) {
                    return "foo";
                }
                return null;
            }
        };
        Gadget gadget = this.makeDefaultGadget().setContext(context);
        this.featureRegistry.addInline("foo", "does-not-matter");
        this.control.replay();
        String rewritten = this.rewrite(gadget, doc);
        Matcher matcher = DOCUMENT_SPLIT_PATTERN.matcher(rewritten);
        Assert.assertTrue((String)"Output is not valid HTML.", (boolean)matcher.matches());
        Assert.assertTrue((String)"DOCTYPE not preserved", (boolean)matcher.group(1).contains(docType));
        Assert.assertTrue((String)"Missing opening html tag", (boolean)matcher.group(1).contains("<html>"));
        Assert.assertTrue((String)"Custom head content is missing.", (boolean)matcher.group(2).contains(head));
        Assert.assertTrue((String)"Forced javascript not included.", (boolean)matcher.group(2).contains("<script src=\"/js/foo\">"));
        Assert.assertFalse((String)"Default styling was injected when a doctype was specified.", (boolean)matcher.group(2).contains("body,td,div,span,p{font-family:arial,sans-serif;}a {color:#0000cc;}a:visited {color:#551a8b;}a:active {color:#ff0000;}body{margin: 0px;padding: 0px;background-color:white;}"));
        Assert.assertTrue((String)"Custom body attributes missing.", (boolean)matcher.group(3).contains(bodyAttr));
        Assert.assertTrue((String)"Original document not preserved.", (boolean)matcher.group(4).contains(body));
        Assert.assertTrue((String)"gadgets.util.runOnLoadHandlers not invoked.", (boolean)matcher.group(4).contains("gadgets.util.runOnLoadHandlers();"));
    }

    @Test
    public void bidiSettings() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Locale language_direction='rtl'/></ModulePrefs><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        this.control.replay();
        String rewritten = this.rewrite(gadget, "");
        Assert.assertTrue((String)"Bi-directional locale settings not preserved.", (boolean)rewritten.contains("<body dir=\"rtl\">"));
    }

    private Set<String> getInjectedScript(String content) {
        Pattern featurePattern = Pattern.compile("(?:.*)<script src=\"\\/js\\/(.*?)\"><\\/script>(?:.*)", 32);
        Matcher matcher = featurePattern.matcher(content);
        Assert.assertTrue((String)"Forced scripts not injected.", (boolean)matcher.matches());
        return Sets.newHashSet((Object[])matcher.group(1).split(":"));
    }

    @Test
    public void forcedFeaturesInjectedExternal() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='foo'/></ModulePrefs><Content type='html'/></Module>";
        final List<String> libs = Arrays.asList("foo", "bar", "baz");
        GadgetContext context = new GadgetContext(){

            public String getParameter(String name) {
                if (name.equals("libs")) {
                    return Join.join((CharSequence)":", (Iterable)libs);
                }
                return null;
            }
        };
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml).setContext(context);
        this.featureRegistry.addInline("foo", "does-not-matter");
        this.featureRegistry.addInline("bar", "does-not-matter");
        this.featureRegistry.addInline("baz", "does-not-matter");
        this.control.replay();
        String rewritten = this.rewrite(gadget, "");
        Set<String> actual = this.getInjectedScript(rewritten);
        ImmutableSortedSet expected = ImmutableSortedSet.of((Comparable[])new String[]{"foo", "bar", "baz"});
        Assert.assertEquals((Object)expected, actual);
    }

    @Test
    public void inlinedFeaturesWhenNothingForced() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='foo'/></ModulePrefs><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        this.featureRegistry.addInline("foo", "foo_content();");
        this.control.replay();
        String rewritten = this.rewrite(gadget, "");
        Assert.assertTrue((String)"Requested scripts not inlined.", (boolean)rewritten.contains("foo_content();"));
    }

    @Test
    public void mixedExternalAndInline() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='foo'/></ModulePrefs><Content type='html'/></Module>";
        final List<String> libs = Arrays.asList("bar", "baz");
        GadgetContext context = new GadgetContext(){

            public String getParameter(String name) {
                if (name.equals("libs")) {
                    return Join.join((CharSequence)":", (Iterable)libs);
                }
                return null;
            }
        };
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml).setContext(context);
        this.featureRegistry.addInline("foo", "foo_content();");
        this.featureRegistry.addInline("bar", "does-not-matter");
        this.featureRegistry.addInline("baz", "does-not-matter");
        this.control.replay();
        String rewritten = this.rewrite(gadget, "");
        Set<String> actual = this.getInjectedScript(rewritten);
        ImmutableSortedSet expected = ImmutableSortedSet.of((Comparable[])new String[]{"bar", "baz"});
        Assert.assertEquals((Object)expected, actual);
        Assert.assertTrue((String)"Requested scripts not inlined.", (boolean)rewritten.contains("foo_content();"));
    }

    @Test
    public void featuresInjectedBeforeExistingScript() throws Exception {
        Gadget gadget = this.makeDefaultGadget();
        this.control.replay();
        String rewritten = this.rewrite(gadget, "<html><head><script src=\"foo.js\"></script></head><body>hello</body></html>");
        Matcher matcher = DOCUMENT_SPLIT_PATTERN.matcher(rewritten);
        Assert.assertTrue((String)"Output is not valid HTML.", (boolean)matcher.matches());
        String headContent = matcher.group(2);
        int userPosition = headContent.indexOf("<script src=\"foo.js\"></script>");
        int ourPosition = headContent.indexOf("<script>");
        Assert.assertTrue((String)"Injected script must come before user script.", (ourPosition < userPosition ? 1 : 0) != 0);
    }

    @Test
    public void featuresDeclaredBeforeUsed() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='foo'/></ModulePrefs><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        this.featureRegistry.addInline("foo", "gadgets.Prefs.setMessages_ = function(){};");
        this.control.replay();
        String rewritten = this.rewrite(gadget, BODY_CONTENT);
        Matcher matcher = DOCUMENT_SPLIT_PATTERN.matcher(rewritten);
        Assert.assertTrue((String)"Output is not valid HTML.", (boolean)matcher.matches());
        String headContent = matcher.group(2);
        int declaredPosition = headContent.indexOf("foo_content();");
        int usedPosition = headContent.indexOf("gadgets.Prefs.setMessages_");
        Assert.assertTrue((String)"Inline JS needs to exist before it is used.", (declaredPosition < usedPosition ? 1 : 0) != 0);
    }

    @Test
    public void urlFeaturesForcedExternal() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='foo'/>  <Require feature='bar'/></ModulePrefs><Content type='html'/></Module>";
        GadgetContext context = new GadgetContext(){

            public String getParameter(String name) {
                if (name.equals("libs")) {
                    return "baz";
                }
                return null;
            }
        };
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml).setContext(context);
        this.featureRegistry.addInline("foo", "foo_content();");
        this.featureRegistry.addExternal("bar", "http://example.org/external.js");
        this.featureRegistry.addInline("baz", "does-not-matter");
        this.control.replay();
        String rewritten = this.rewrite(gadget, "");
        Set<String> actual = this.getInjectedScript(rewritten);
        ImmutableSortedSet expected = ImmutableSortedSet.of((Comparable)((Object)"baz"));
        Assert.assertEquals((Object)expected, actual);
        Assert.assertTrue((String)"Requested scripts not inlined.", (boolean)rewritten.contains("foo_content();"));
        Assert.assertTrue((String)"Forced external file not forced.", (boolean)rewritten.contains("<script src=\"http://example.org/external.js\">"));
    }

    private JSONObject getConfigJson(String content) throws JSONException {
        Pattern prefsPattern = Pattern.compile("(?:.*)gadgets\\.config\\.init\\((.*)\\);(?:.*)", 32);
        Matcher matcher = prefsPattern.matcher(content);
        Assert.assertTrue((String)"gadgets.config.init not invoked.", (boolean)matcher.matches());
        return new JSONObject(matcher.group(1));
    }

    @Test
    public void featureConfigurationInjected() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='foo'/></ModulePrefs><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        this.featureRegistry.addInline("foo", "");
        JSONObject conf = new JSONObject();
        conf.put("foo", (Object)"blah");
        EasyMock.expect((Object)this.config.getJsonObject("default", "gadgets.features")).andReturn((Object)conf);
        this.control.replay();
        String rewritten = this.rewrite(gadget, "");
        JSONObject json = this.getConfigJson(rewritten);
        Assert.assertEquals((Object)"blah", (Object)json.get("foo"));
    }

    @Test
    public void featureConfigurationForced() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='foo'/></ModulePrefs><Content type='html'/></Module>";
        GadgetContext context = new GadgetContext(){

            public String getParameter(String name) {
                if (name.equals("libs")) {
                    return "bar";
                }
                return null;
            }
        };
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml).setContext(context);
        this.featureRegistry.addInline("foo", "");
        this.featureRegistry.addInline("bar", "");
        JSONObject conf = new JSONObject();
        conf.put("foo", (Object)"blah").put("bar", (Object)"baz");
        EasyMock.expect((Object)this.config.getJsonObject("default", "gadgets.features")).andReturn((Object)conf);
        this.control.replay();
        String rewritten = this.rewrite(gadget, "");
        JSONObject json = this.getConfigJson(rewritten);
        Assert.assertEquals((Object)"blah", (Object)json.get("foo"));
        Assert.assertEquals((Object)"baz", (Object)json.get("bar"));
    }

    @Test
    public void gadgetsUtilConfigInjected() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='foo'>    <Param name='bar'>baz</Param>  </Require></ModulePrefs><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        this.featureRegistry.addInline("foo", "");
        JSONObject conf = new JSONObject();
        conf.put("foo", (Object)"blah");
        EasyMock.expect((Object)this.config.getJsonObject("default", "gadgets.features")).andReturn((Object)conf);
        this.control.replay();
        String rewritten = this.rewrite(gadget, "");
        JSONObject json = this.getConfigJson(rewritten);
        Assert.assertEquals((Object)"blah", (Object)json.get("foo"));
        JSONObject util = json.getJSONObject("core.util");
        JSONObject foo = util.getJSONObject("foo");
        Assert.assertEquals((Object)"baz", (Object)foo.get("bar"));
    }

    @Test
    public void userPrefsInitializationInjected() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Locale>    <msg name='one'>foo</msg>    <msg name='two'>bar</msg>  </Locale></ModulePrefs><UserPref name='pref_one' default_value='default_one'/><UserPref name='pref_two'/><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        this.control.replay();
        String rewritten = this.rewrite(gadget, "");
        Pattern prefsPattern = Pattern.compile("(?:.*)gadgets\\.Prefs\\.setMessages_\\((.*)\\);(?:.*)", 32);
        Matcher matcher = prefsPattern.matcher(rewritten);
        Assert.assertTrue((String)"gadgets.Prefs.setMessages_ not invoked.", (boolean)matcher.matches());
        JSONObject json = new JSONObject(matcher.group(1));
        Assert.assertEquals((Object)"foo", (Object)json.get("one"));
        Assert.assertEquals((Object)"bar", (Object)json.get("two"));
        Pattern defaultsPattern = Pattern.compile("(?:.*)gadgets\\.Prefs\\.setDefaultPrefs_\\((.*)\\);(?:.*)", 32);
        Matcher defaultsMatcher = defaultsPattern.matcher(rewritten);
        Assert.assertTrue((String)"gadgets.Prefs.setDefaultPrefs_ not invoked.", (boolean)defaultsMatcher.matches());
        JSONObject defaultsJson = new JSONObject(defaultsMatcher.group(1));
        Assert.assertEquals((long)2L, (long)defaultsJson.length());
        Assert.assertEquals((Object)"default_one", (Object)defaultsJson.get("pref_one"));
        Assert.assertEquals((Object)"", (Object)defaultsJson.get("pref_two"));
    }

    @Test(expected=RuntimeException.class)
    public void unsupportedFeatureThrows() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Require feature='foo'/></ModulePrefs><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        this.control.replay();
        this.rewrite(gadget, "");
    }

    @Test
    public void unsupportedOptionalFeatureDoesNotThrow() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Optional feature='foo'/></ModulePrefs><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        this.control.replay();
        this.rewrite(gadget, "");
    }

    @Test
    public void multipleUnsupportedOptionalFeaturesDoNotThrow() throws Exception {
        String gadgetXml = "<Module><ModulePrefs title=''>  <Optional feature='foo'/>  <Optional feature='bar'/></ModulePrefs><Content type='html'/></Module>";
        Gadget gadget = this.makeGadgetWithSpec(gadgetXml);
        this.control.replay();
        this.rewrite(gadget, "");
    }

    private JSONObject getPreloadedJson(String content) throws JSONException {
        Pattern preloadPattern = Pattern.compile("(?:.*)gadgets\\.io\\.preloaded_=\\{(.*?)\\};(?:.*)", 32);
        Matcher matcher = preloadPattern.matcher(content);
        Assert.assertTrue((String)"gadgets.io.preloaded not set.", (boolean)matcher.matches());
        return new JSONObject('{' + matcher.group(1) + '}');
    }

    @Test
    public void preloadsInjected() throws Exception {
        final HashMap preloadData = Maps.newHashMap();
        preloadData.put("string", "string");
        preloadData.put("integer", 99);
        preloadData.put("double", 4343434.345345);
        Preloads preloads = new Preloads(){

            public PreloadedData getData(final String key) {
                return new PreloadedData(){

                    public Object toJson() {
                        return preloadData.get(key);
                    }
                };
            }

            public Set<String> getKeys() {
                return preloadData.keySet();
            }
        };
        Gadget gadget = this.makeDefaultGadget().setPreloads(preloads);
        this.control.replay();
        String rewritten = this.rewrite(gadget, "");
        JSONObject json = this.getPreloadedJson(rewritten);
        for (Map.Entry entry : preloadData.entrySet()) {
            Assert.assertEquals(entry.getValue(), (Object)json.get((String)entry.getKey()));
        }
    }

    @Test
    public void failedPreloadHandledGracefully() throws Exception {
        Preloads preloads = new Preloads(){

            public PreloadedData getData(String key) throws PreloadException {
                throw new PreloadException("broken");
            }

            public Set<String> getKeys() {
                return ImmutableSortedSet.of((Comparable)((Object)"foo"));
            }
        };
        Gadget gadget = this.makeDefaultGadget().setPreloads(preloads);
        this.control.replay();
        String rewritten = this.rewrite(gadget, "");
        JSONObject json = this.getPreloadedJson(rewritten);
        Assert.assertEquals((long)0L, (long)json.length());
    }

    private String getBaseElement(String content) {
        Matcher matcher = DOCUMENT_SPLIT_PATTERN.matcher(content);
        Assert.assertTrue((String)"Output is not valid HTML.", (boolean)matcher.matches());
        Pattern baseElementPattern = Pattern.compile("^<base href=\"(.*?)\">(?:.*)", 32);
        Matcher baseElementMatcher = baseElementPattern.matcher(matcher.group(2));
        Assert.assertTrue((String)"Base element does not exist at the beginning of the head element.", (boolean)baseElementMatcher.matches());
        return baseElementMatcher.group(1);
    }

    @Test
    public void baseElementInsertedWhenContentIsInline() throws Exception {
        Gadget gadget = this.makeDefaultGadget();
        EasyMock.expect((Object)this.config.get("default", "gadgets.insertBaseElement")).andReturn((Object)"true");
        this.control.replay();
        String rewritten = this.rewrite(gadget, BODY_CONTENT);
        String base = this.getBaseElement(rewritten);
        Assert.assertEquals((Object)SPEC_URL.toString(), (Object)base);
    }

    @Test
    public void baseElementInsertedWhenContentIsProxied() throws Exception {
        Gadget gadget = this.makeDefaultGadget();
        String viewUrl = "http://example.org/view.html";
        String xml = "<Content href='" + viewUrl + "'/>";
        View fakeView = new View("foo", Arrays.asList(XmlUtil.parse((String)xml)), SPEC_URL);
        gadget.setCurrentView(fakeView);
        EasyMock.expect((Object)this.config.get("default", "gadgets.insertBaseElement")).andReturn((Object)"true");
        this.control.replay();
        String rewritten = this.rewrite(gadget, BODY_CONTENT);
        String base = this.getBaseElement(rewritten);
        Assert.assertEquals((Object)viewUrl, (Object)base);
    }

    @Test
    public void baseElementNotInsertedWhenConfigDoesNotAllowIt() throws Exception {
        Gadget gadget = this.makeDefaultGadget();
        EasyMock.expect((Object)this.config.get("default", "gadgets.insertBaseElement")).andReturn((Object)"false");
        this.control.replay();
        String rewritten = this.rewrite(gadget, BODY_CONTENT);
        Assert.assertFalse((String)"Base element injected incorrectly.", (boolean)rewritten.contains("<base"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FakeGadgetFeatureRegistry
    extends GadgetFeatureRegistry {
        private final Map<String, GadgetFeature> features = Maps.newHashMap();

        public void addInline(String name, String content) throws GadgetException {
            ArrayList libs = Lists.newArrayList();
            libs.add(JsLibrary.create((JsLibrary.Type)JsLibrary.Type.INLINE, (String)content, (String)name, null));
            this.features.put(name, new GadgetFeature(name, (List)libs, null));
        }

        public void addExternal(String name, String content) throws GadgetException {
            ArrayList libs = Lists.newArrayList();
            libs.add(JsLibrary.create((JsLibrary.Type)JsLibrary.Type.URL, (String)content, (String)name, null));
            this.features.put(name, new GadgetFeature(name, (List)libs, null));
        }

        public FakeGadgetFeatureRegistry() throws GadgetException {
            super(null, null);
        }

        public Collection<GadgetFeature> getFeatures(Collection<String> needed) {
            return this.getFeatures(needed, new HashSet<String>());
        }

        public Collection<GadgetFeature> getFeatures(Collection<String> needed, Collection<String> unsupported) {
            ArrayList out = Lists.newArrayList();
            for (String name : needed) {
                if (this.features.containsKey(name)) {
                    out.add(this.features.get(name));
                    continue;
                }
                unsupported.add(name);
            }
            return out;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FakeUrlGenerator
    implements UrlGenerator {
        private FakeUrlGenerator() {
        }

        public String getBundledJsParam(Collection<String> features, GadgetContext context) {
            throw new UnsupportedOperationException();
        }

        public String getIframeUrl(Gadget gadget) {
            throw new UnsupportedOperationException();
        }

        public String getBundledJsUrl(Collection<String> features, GadgetContext context) {
            return "/js/" + Join.join((CharSequence)":", features);
        }
    }

    private static class FakeMessageBundleFactory
    implements MessageBundleFactory {
        private FakeMessageBundleFactory() {
        }

        public MessageBundle getBundle(GadgetSpec spec, Locale locale, boolean ignoreCache) {
            LocaleSpec localeSpec = spec.getModulePrefs().getLocale(locale);
            if (localeSpec == null) {
                return MessageBundle.EMPTY;
            }
            return spec.getModulePrefs().getLocale(locale).getMessageBundle();
        }
    }
}

