/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewriterResults;

class AppendingRewriter
implements ContentRewriter {
    private String appender;
    private final long cacheTtl;

    AppendingRewriter(String appender) {
        this.appender = appender;
        this.cacheTtl = 0L;
    }

    AppendingRewriter(String appender, long cacheTtl) {
        this.appender = appender;
        this.cacheTtl = cacheTtl;
    }

    public RewriterResults rewrite(HttpRequest request, HttpResponse original, MutableContent c) {
        c.setContent(c.getContent() + this.appender);
        return RewriterResults.cacheable((long)this.cacheTtl);
    }

    public RewriterResults rewrite(Gadget gadget, MutableContent content) {
        content.setContent(content.getContent() + this.appender);
        return RewriterResults.cacheable((long)this.cacheTtl);
    }

    void setAppender(String newAppender) {
        this.appender = newAppender;
    }
}

