/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Lists;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.rewrite.BaseRewriterTestCase;
import org.apache.shindig.gadgets.rewrite.CssRewriter;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;

public class CssRewriterTest
extends BaseRewriterTestCase {
    private Uri dummyUri;

    protected void setUp() throws Exception {
        super.setUp();
        this.dummyUri = Uri.parse((String)"http://www.w3c.org");
    }

    private void validateRewritten(String content, Uri base, LinkRewriter rewriter, String expected) {
        CssRewriterTest.assertEquals((String)expected, (String)CssRewriter.rewrite((String)content, (Uri)base, (LinkRewriter)rewriter));
    }

    private void validateRewritten(String content, String expected) {
        this.validateRewritten(content, this.dummyUri, this.defaultLinkRewriter, expected);
    }

    public void testUrlDeclarationRewrite() {
        String original = "div {list-style-image:url('http://a.b.com/bullet.gif');list-style-position:outside;margin:5px;padding:0}\n.someid {background-image:url(http://a.b.com/bigimg.png);float:right;width:165px;height:23px;margin-top:4px;margin-left:5px}";
        String rewritten = "div {list-style-image:url(\"http://www.test.com/dir/proxy?url=http%3A%2F%2Fa.b.com%2Fbullet.gif&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334\");list-style-position:outside;margin:5px;padding:0}\n.someid {background-image:url(\"http://www.test.com/dir/proxy?url=http%3A%2F%2Fa.b.com%2Fbigimg.png&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334\");float:right;width:165px;height:23px;margin-top:4px;margin-left:5px}";
        this.validateRewritten(original, rewritten);
    }

    public void testExtractImports() {
        String original = " @import url(www.example.org/some.css);\n div { color: blue; }\n@import url('www.example.org/someother.css')\n p { color: black; }\n@import url(\"www.example.org/another.css\")\n span { color: red; }";
        String expected = " div { color: blue; }\np { color: black; }\nspan { color: red; }";
        StringWriter sw = new StringWriter();
        List stringList = CssRewriter.rewrite((Reader)new StringReader(original), (Uri)this.dummyUri, (LinkRewriter)this.defaultLinkRewriter, (Writer)sw, (boolean)true);
        CssRewriterTest.assertEquals((String)expected, (String)sw.toString());
        CssRewriterTest.assertEquals((Object)stringList, (Object)Lists.newArrayList((Object[])new String[]{"www.example.org/some.css", "www.example.org/someother.css", "www.example.org/another.css"}));
    }
}

