/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.lexer;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.rewrite.BaseRewriterTestCase;
import org.apache.shindig.gadgets.rewrite.lexer.HtmlRewriter;
import org.apache.shindig.gadgets.rewrite.lexer.HtmlTagTransformer;
import org.apache.shindig.gadgets.rewrite.lexer.JavascriptTagMerger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavascriptTagMergerTest
extends BaseRewriterTestCase {
    private Uri dummyUri;
    private Map<String, HtmlTagTransformer> defaultTransformerMap;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.dummyUri = Uri.parse((String)"http://www.w3c.org");
        Uri relativeBase = Uri.parse((String)"http://a.b.com/");
        this.defaultTransformerMap = new ImmutableMap.Builder().put((Object)"script", (Object)new JavascriptTagMerger(JavascriptTagMergerTest.createSpecWithoutRewrite(), this.defaultRewriterFeature, "http://www.test.com/concat?", relativeBase)).build();
    }

    private void validateRewritten(String content, Uri base, Map<String, HtmlTagTransformer> transformerMap, String expected) {
        JavascriptTagMergerTest.assertEquals((String)expected, (String)HtmlRewriter.rewrite((String)content, (Uri)base, transformerMap));
    }

    private void validateRewritten(String content, String expected) {
        this.validateRewritten(content, this.dummyUri, this.defaultTransformerMap, expected);
    }

    public void testPreserveNoExternal() {
        String original = "<script type=\"text/javascript\">\ndoSomething\n</script>";
        this.validateRewritten(original, original);
    }

    public void testPreserveNoScript() {
        String original = "<html><div id=\"test\">ceci ne pas une script</div></html>";
        this.validateRewritten(original, original);
    }

    public void testPreserveWithComment() {
        String original = "<script type=\"text/javascript\"><!--\ndoSomething\n--></script>";
        this.validateRewritten(original, original);
    }

    public void testSingleScriptReWrite() {
        String original = "<script src=\"http://a.b.com/1.js\"></script>";
        String rewritten = "<script src=\"http://www.test.com/concat?rewriteMime=text/javascript&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334&1=http%3A%2F%2Fa.b.com%2F1.js\" type=\"text/javascript\"></script>";
        this.validateRewritten(original, rewritten);
    }

    public void testTwoScriptReWrite() {
        String original = "<script src=\"http://a.b.com/1.js\"></script>\n<script src=\"http://a.b.com/2.js\"></script>";
        String rewritten = "<script src=\"http://www.test.com/concat?rewriteMime=text/javascript&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334&1=http%3A%2F%2Fa.b.com%2F1.js&2=http%3A%2F%2Fa.b.com%2F2.js\" type=\"text/javascript\"></script>";
        this.validateRewritten(original, rewritten);
    }

    public void testLeadAndTrailingScriptReWrite() {
        String original = "<script>\ndoSomething\n</script>\n<script src=\"http://a.b.com/1.js\"></script>\n<script src=\"http://a.b.com/2.js\"></script>\n<script>\ndoSomething\n</script>";
        String rewritten = "<script type=\"text/javascript\">\ndoSomething\n</script><script src=\"http://www.test.com/concat?rewriteMime=text/javascript&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334&1=http%3A%2F%2Fa.b.com%2F1.js&2=http%3A%2F%2Fa.b.com%2F2.js\" type=\"text/javascript\"></script><script type=\"text/javascript\">\ndoSomething\n</script>";
        this.validateRewritten(original, rewritten);
    }

    public void testInterspersed() {
        String original = "<script src=\"http://a.b.com/1.js\"></script>\n<script src=\"http://a.b.com/2.js\"></script>\n<script type=\"text/javascript\"><!-- doSomething --></script>\n<script src=\"http://a.b.com/3.js\"></script>\n<script src=\"http://a.b.com/4.js\"></script>";
        String rewritten = "<script src=\"http://www.test.com/concat?rewriteMime=text/javascript&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334&1=http%3A%2F%2Fa.b.com%2F1.js&2=http%3A%2F%2Fa.b.com%2F2.js\" type=\"text/javascript\"></script><script type=\"text/javascript\"><!-- doSomething --></script><script src=\"http://www.test.com/concat?rewriteMime=text/javascript&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334&1=http%3A%2F%2Fa.b.com%2F3.js&2=http%3A%2F%2Fa.b.com%2F4.js\" type=\"text/javascript\"></script>";
        this.validateRewritten(original, rewritten);
    }

    public void testDerelativizeHostRelative() {
        String original = "<script src=\"/1.js\"></script>";
        String rewritten = "<script src=\"http://www.test.com/concat?rewriteMime=text/javascript&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334&1=http%3A%2F%2Fa.b.com%2F1.js\" type=\"text/javascript\"></script>";
        this.validateRewritten(original, rewritten);
    }

    public void testDerelativizePathRelative() {
        String original = "<script src=\"1.js\"></script>";
        String rewritten = "<script src=\"http://www.test.com/concat?rewriteMime=text/javascript&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334&1=http%3A%2F%2Fa.b.com%2F1.js\" type=\"text/javascript\"></script>";
        this.validateRewritten(original, rewritten);
    }
}

