/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.lexer;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.rewrite.BaseRewriterTestCase;
import org.apache.shindig.gadgets.rewrite.lexer.HtmlRewriter;
import org.apache.shindig.gadgets.rewrite.lexer.HtmlTagTransformer;
import org.apache.shindig.gadgets.rewrite.lexer.LinkingTagRewriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkingTagRewriterTest
extends BaseRewriterTestCase {
    private Uri dummyUri;
    private Map<String, HtmlTagTransformer> defaultTransformerMap;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.dummyUri = Uri.parse((String)"http://www.w3c.org");
        Uri relativeBase = Uri.parse((String)"http://a.b.com/");
        LinkingTagRewriter rewriter = new LinkingTagRewriter(this.defaultLinkRewriter, relativeBase);
        this.defaultTransformerMap = Maps.newHashMap();
        for (String tag : rewriter.getSupportedTags()) {
            this.defaultTransformerMap.put(tag, (HtmlTagTransformer)rewriter);
        }
    }

    private void validateRewritten(String content, Uri base, Map<String, HtmlTagTransformer> transformerMap, String expected) {
        LinkingTagRewriterTest.assertEquals((String)expected, (String)HtmlRewriter.rewrite((String)content, (Uri)base, transformerMap));
    }

    private void validateRewritten(String content, String expected) {
        this.validateRewritten(content, this.dummyUri, this.defaultTransformerMap, expected);
    }

    public void testStandardRewrite() {
        String original = "<img src=\"http://a.b.com/img.gif\"></img>\n<IMG src=\"http://a.b.com/img.gif\"/>\n<eMbeD src=\"http://a.b.com/some.mov\" width=\"100\" height=\"30px\"/>";
        String expected = "<img src=\"http://www.test.com/dir/proxy?url=http%3A%2F%2Fa.b.com%2Fimg.gif&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334\"></img>\n<IMG src=\"http://www.test.com/dir/proxy?url=http%3A%2F%2Fa.b.com%2Fimg.gif&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334\"/>\n<eMbeD src=\"http://www.test.com/dir/proxy?url=http%3A%2F%2Fa.b.com%2Fsome.mov&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334\" width=\"100\" height=\"30px\"/>";
        this.validateRewritten(original, expected);
    }
}

