/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.gadgets.EasyMockTestCase;
import org.apache.shindig.gadgets.servlet.ProxyServletRequest;
import org.easymock.EasyMock;

public class ProxyServletRequestTest
extends EasyMockTestCase {
    private static final String URL = "http://proxy/url";
    private final HttpServletRequest request = this.mock(HttpServletRequest.class);

    public ProxyServletRequest setupMockRequest(String url) {
        EasyMock.expect((Object)this.request.getRequestURI()).andReturn((Object)url).atLeastOnce();
        EasyMock.expect((Object)this.request.getParameter("url")).andReturn((Object)URL).anyTimes();
        this.replay();
        return new ProxyServletRequest(this.request);
    }

    public void testOldRequestSyntax() throws Exception {
        ProxyServletRequest req = this.setupMockRequest("http://localhost/gadgets/proxy?url=http://proxy/url");
        ProxyServletRequestTest.assertFalse((boolean)req.isUsingChainedSyntax());
        ProxyServletRequestTest.assertEquals((String)URL, (String)req.getParameter("url"));
        this.verify();
    }

    public void testChainedSyntaxWithNoParameters() throws Exception {
        ProxyServletRequest req = this.setupMockRequest("http://localhost/gadgets/proxy//http://remote/proxy?query=foo");
        ProxyServletRequestTest.assertTrue((boolean)req.isUsingChainedSyntax());
        ProxyServletRequestTest.assertEquals((String)"http://remote/proxy?query=foo", (String)req.getParameter("url"));
        ProxyServletRequestTest.assertNull((Object)req.getParameter("query"));
        this.verify();
    }

    public void testChainedSyntaxWithOneParameter() throws Exception {
        ProxyServletRequest req = this.setupMockRequest("http://localhost/gadgets/proxy/nocache=1/http://remote/proxy?nocache=0");
        ProxyServletRequestTest.assertTrue((boolean)req.isUsingChainedSyntax());
        ProxyServletRequestTest.assertEquals((String)"http://remote/proxy?nocache=0", (String)req.getParameter("url"));
        ProxyServletRequestTest.assertEquals((String)"1", (String)req.getParameter("nocache"));
        this.verify();
    }

    public void testChainedSyntaxWithParameters() throws Exception {
        ProxyServletRequest req = this.setupMockRequest("http://u:p@127.0.0.1:80/g/proxy/a=b%20+c&url=u/http://r/p?a=d+e");
        ProxyServletRequestTest.assertTrue((boolean)req.isUsingChainedSyntax());
        ProxyServletRequestTest.assertEquals((String)"http://r/p?a=d+e", (String)req.getParameter("url"));
        ProxyServletRequestTest.assertEquals((String)"b  c", (String)req.getParameter("a"));
        this.verify();
    }
}

