/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junitx.framework.ComparableAssert;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.util.DateUtil;
import org.apache.shindig.common.util.TimeSource;
import org.apache.shindig.gadgets.GadgetTestFixture;
import org.apache.shindig.gadgets.LockedDomainService;
import org.apache.shindig.gadgets.servlet.HttpServletResponseRecorder;
import org.apache.shindig.gadgets.servlet.HttpUtil;

public class ServletTestFixture
extends GadgetTestFixture {
    public final HttpServletRequest request = this.mock(HttpServletRequest.class);
    public final HttpServletResponse response = this.mock(HttpServletResponse.class);
    public final HttpServletResponseRecorder recorder = new HttpServletResponseRecorder(this.response);
    public final LockedDomainService lockedDomainService = this.mock(LockedDomainService.class);
    private final long testStartTime = this.timeSource.currentTimeMillis();

    public ServletTestFixture() {
        HttpUtil.setTimeSource((TimeSource)this.timeSource);
    }

    public void checkCacheControlHeaders(int ttl, boolean noProxy) {
        long expires = DateUtil.parseDate((String)this.recorder.getHeader("Expires")).getTime();
        long lowerBound = this.testStartTime + 1000L * (long)(ttl - 1);
        long upperBound = lowerBound + 2000L;
        ComparableAssert.assertGreater((String)("Expires should be at least " + ttl + " seconds more than start time."), (Comparable)Long.valueOf(lowerBound), (Comparable)Long.valueOf(expires));
        ComparableAssert.assertLesser((String)"Expires should be within 2 seconds of the requested value.", (Comparable)Long.valueOf(upperBound), (Comparable)Long.valueOf(expires));
        if (ttl == 0) {
            ServletTestFixture.assertEquals((String)"no-cache", (String)this.recorder.getHeader("Pragma"));
            ServletTestFixture.assertEquals((String)"no-cache", (String)this.recorder.getHeader("Cache-Control"));
        } else {
            List<String> directives = Arrays.asList(StringUtils.split((String)this.recorder.getHeader("Cache-Control"), (char)','));
            ServletTestFixture.assertTrue((String)"Incorrect max-age set.", (boolean)directives.contains("max-age=" + ttl));
            if (noProxy) {
                ServletTestFixture.assertTrue((String)"No private Cache-Control directive was set.", (boolean)directives.contains("private"));
            } else {
                ServletTestFixture.assertTrue((String)"No public Cache-Control directive was set.", (boolean)directives.contains("public"));
            }
        }
    }
}

