/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import java.util.Map;
import junit.framework.TestCase;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.SpecParserException;

public class FeatureTest
extends TestCase {
    public void testRequire() throws Exception {
        String xml = "<Require feature=\"foo\"/>";
        Feature feature = new Feature(XmlUtil.parse((String)xml));
        FeatureTest.assertEquals((String)"foo", (String)feature.getName());
        FeatureTest.assertEquals((boolean)true, (boolean)feature.getRequired());
    }

    public void testOptional() throws Exception {
        String xml = "<Optional feature=\"foo\"/>";
        Feature feature = new Feature(XmlUtil.parse((String)xml));
        FeatureTest.assertEquals((String)"foo", (String)feature.getName());
        FeatureTest.assertEquals((boolean)false, (boolean)feature.getRequired());
    }

    public void testParams() throws Exception {
        String key = "bar";
        String value = "Hello, World!";
        String xml = "<Require feature=\"foo\">  <Param name=\"" + key + "\">" + value + "</Param>" + "</Require>";
        Feature feature = new Feature(XmlUtil.parse((String)xml));
        Map params = feature.getParams();
        FeatureTest.assertEquals((int)1, (int)params.size());
        FeatureTest.assertEquals((String)value, (String)((String)params.get(key)));
    }

    public void testDoesNotLikeUnnamedFeatures() throws Exception {
        String xml = "<Require/>";
        try {
            new Feature(XmlUtil.parse((String)xml));
            FeatureTest.fail((String)"No exception thrown when an unnamed feature is passed.");
        }
        catch (SpecParserException specParserException) {
            // empty catch block
        }
    }

    public void testEnforceParamNames() throws Exception {
        String xml = "<Require feature=\"foo\"><Param>Test</Param></Require>";
        try {
            new Feature(XmlUtil.parse((String)xml));
            FeatureTest.fail((String)"No exception thrown when an unnamed parameter is passed.");
        }
        catch (SpecParserException specParserException) {
            // empty catch block
        }
    }
}

