/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.util.List;
import java.util.Map;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchResponseUtils {
    public static JSONObject getResponseAsJson(HttpResponse response, String body) throws JSONException {
        JSONObject resp = new JSONObject();
        resp.put("rc", response.getHttpStatusCode());
        resp.put("body", (Object)body);
        JSONObject headers = new JSONObject();
        FetchResponseUtils.addHeaders(headers, response, "set-cookie");
        FetchResponseUtils.addHeaders(headers, response, "location");
        resp.put("headers", (Object)headers);
        for (Map.Entry<String, String> entry : response.getMetadata().entrySet()) {
            resp.put(entry.getKey(), (Object)entry.getValue());
        }
        return resp;
    }

    private static void addHeaders(JSONObject headers, HttpResponse response, String headerName) throws JSONException {
        List<String> values = response.getHeaders(headerName);
        if (!values.isEmpty()) {
            headers.put(headerName.toLowerCase(), (Object)new JSONArray(values));
        }
    }
}

