/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.lexer;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.shindig.common.ContainerConfig;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.CssRewriter;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.ProxyingLinkRewriter;
import org.apache.shindig.gadgets.rewrite.RewriterResults;
import org.apache.shindig.gadgets.rewrite.lexer.HtmlRewriter;
import org.apache.shindig.gadgets.rewrite.lexer.JavascriptTagMerger;
import org.apache.shindig.gadgets.rewrite.lexer.LinkingTagRewriter;
import org.apache.shindig.gadgets.rewrite.lexer.StyleTagRewriter;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.View;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Singleton
public class DefaultContentRewriter
implements ContentRewriter {
    private final GadgetSpecFactory specFactory;
    private final ContainerConfig config;
    static final String CONTENT_REWRITE_KEY = "gadgets.content-rewrite";
    static final String INCLUDE_TAGS_KEY = "include-tags";
    static final String INCLUDE_URLS_KEY = "include-urls";
    static final String EXCLUDE_TAGS_KEY = "exclude-urls";
    static final String PROXY_URL_KEY = "proxy-url";
    static final String CONCAT_URL_KEY = "concat-url";
    static final String EXPIRES_KEY = "expires";

    @Inject
    public DefaultContentRewriter(GadgetSpecFactory specFactory, ContainerConfig config) {
        this.specFactory = specFactory;
        this.config = config;
    }

    public RewriterResults rewrite(HttpRequest request, HttpResponse original, MutableContent content) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(content.getContent().length() * 110 / 100);
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)baos, original.getEncoding());
            String mimeType = original.getHeader("Content-Type");
            if (request.getRewriteMimeType() != null) {
                mimeType = request.getRewriteMimeType();
            }
            GadgetSpec spec = null;
            if (request.getGadget() != null) {
                spec = this.specFactory.getGadgetSpec(request.getGadget().toJavaUri(), false);
            }
            if (this.rewrite(spec, request.getUri(), content, mimeType, output, request.getContainer())) {
                content.setContent(new String(baos.toByteArray()));
                return RewriterResults.cacheableIndefinitely();
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        catch (GadgetException ge) {
            // empty catch block
        }
        return null;
    }

    public RewriterResults rewrite(Gadget gadget, MutableContent content) {
        StringWriter sw = new StringWriter();
        GadgetSpec spec = gadget.getSpec();
        Uri base = spec.getUrl();
        View view = gadget.getCurrentView();
        if (view != null && view.getHref() != null) {
            base = view.getHref();
        }
        if (this.rewrite(spec, base, content, "text/html", sw, gadget.getContext().getContainer())) {
            content.setContent(sw.toString());
            return RewriterResults.cacheableIndefinitely();
        }
        return null;
    }

    private boolean rewrite(GadgetSpec spec, Uri source, MutableContent mc, String mimeType, Writer w, String container) {
        ContentRewriterFeature rewriterFeature;
        if (spec == null) {
            return false;
        }
        JSONObject contentRewrite = this.config.getJsonObject(container, CONTENT_REWRITE_KEY);
        try {
            JSONArray jsonTags = contentRewrite.getJSONArray(INCLUDE_TAGS_KEY);
            HashSet<String> tags = new HashSet<String>();
            int j = jsonTags.length();
            for (int i = 0; i < j; ++i) {
                tags.add(jsonTags.getString(i).toLowerCase());
            }
            rewriterFeature = new ContentRewriterFeature(spec, contentRewrite.getString(INCLUDE_URLS_KEY), contentRewrite.getString(EXCLUDE_TAGS_KEY), contentRewrite.getString(EXPIRES_KEY), tags);
        }
        catch (JSONException e) {
            return false;
        }
        if (!rewriterFeature.isRewriteEnabled()) {
            return false;
        }
        if (this.isHTML(mimeType)) {
            HashMap transformerMap = Maps.newHashMap();
            if (this.getProxyUrl(container) != null) {
                LinkRewriter linkRewriter = this.createLinkRewriter(spec, rewriterFeature, container);
                LinkingTagRewriter rewriter = new LinkingTagRewriter(linkRewriter, source);
                HashSet toProcess = Sets.newHashSet(rewriter.getSupportedTags());
                toProcess.retainAll(rewriterFeature.getIncludedTags());
                for (String tag : toProcess) {
                    transformerMap.put(tag, rewriter);
                }
                if (rewriterFeature.getIncludedTags().contains("style")) {
                    transformerMap.put("style", new StyleTagRewriter(source, linkRewriter));
                }
            }
            if (this.getConcatUrl(container) != null && rewriterFeature.getIncludedTags().contains("script")) {
                transformerMap.put("script", new JavascriptTagMerger(spec, rewriterFeature, this.getConcatUrl(container), source));
            }
            HtmlRewriter.rewrite(new StringReader(mc.getContent()), source, transformerMap, w);
            return true;
        }
        if (this.isCSS(mimeType)) {
            if (this.getProxyUrl(container) != null) {
                CssRewriter.rewrite(new StringReader(mc.getContent()), source, this.createLinkRewriter(spec, rewriterFeature, container), w, false);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isHTML(String mime) {
        return mime != null && mime.toLowerCase().contains("html");
    }

    private boolean isCSS(String mime) {
        return mime != null && mime.toLowerCase().contains("css");
    }

    protected String getProxyUrl(String container) {
        JSONObject contentRewrite = this.config.getJsonObject(container, CONTENT_REWRITE_KEY);
        try {
            return contentRewrite.getString(PROXY_URL_KEY);
        }
        catch (JSONException e) {
            return null;
        }
    }

    protected String getConcatUrl(String container) {
        JSONObject contentRewrite = this.config.getJsonObject(container, CONTENT_REWRITE_KEY);
        try {
            return contentRewrite.getString(CONCAT_URL_KEY);
        }
        catch (JSONException e) {
            return null;
        }
    }

    protected LinkRewriter createLinkRewriter(GadgetSpec spec, ContentRewriterFeature rewriterFeature, String container) {
        return new ProxyingLinkRewriter(spec.getUrl(), rewriterFeature, this.getProxyUrl(container));
    }
}

