/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.UrlGenerator;
import org.apache.shindig.gadgets.UrlValidationStatus;
import org.apache.shindig.gadgets.render.Renderer;
import org.apache.shindig.gadgets.render.RenderingResults;
import org.apache.shindig.gadgets.servlet.HttpGadgetContext;

public class GadgetRenderingServlet
extends InjectedServlet {
    static final int DEFAULT_CACHE_TTL = 300;
    private Renderer renderer;
    private UrlGenerator urlGenerator;

    @Inject
    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    @Inject
    public void setUrlGenerator(UrlGenerator gadgetUrlGenerator) {
        this.urlGenerator = gadgetUrlGenerator;
    }

    private void render(HttpServletRequest req, HttpServletResponse resp, UrlValidationStatus urlstatus) throws IOException {
        if (req.getHeader("X-shindig-dos") != null) {
            resp.sendError(403);
            return;
        }
        resp.setContentType("text/html");
        resp.setCharacterEncoding("UTF-8");
        HttpGadgetContext context = new HttpGadgetContext(req);
        RenderingResults results = this.renderer.render(context);
        switch (results.getStatus()) {
            case OK: {
                if (((GadgetContext)context).getIgnoreCache() || urlstatus == UrlValidationStatus.INVALID) {
                    HttpUtil.setCachingHeaders((HttpServletResponse)resp, (int)0);
                } else if (urlstatus == UrlValidationStatus.VALID_VERSIONED) {
                    HttpUtil.setCachingHeaders((HttpServletResponse)resp, (boolean)true);
                } else {
                    int ttl = 300;
                    String ttlStr = req.getParameter("refresh");
                    if (ttlStr != null) {
                        ttl = Integer.parseInt(ttlStr);
                    }
                    HttpUtil.setCachingHeaders((HttpServletResponse)resp, (int)ttl, (boolean)true);
                }
                resp.getWriter().print(results.getContent());
                break;
            }
            case ERROR: {
                resp.getWriter().print(StringEscapeUtils.escapeHtml((String)results.getErrorMessage()));
                break;
            }
            case MUST_REDIRECT: {
                resp.sendRedirect(results.getRedirect().toString());
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        UrlValidationStatus urlstatus = this.getUrlStatus(req);
        if (req.getHeader("If-Modified-Since") != null && !"1".equals(req.getParameter("nocache")) && urlstatus == UrlValidationStatus.VALID_VERSIONED) {
            resp.setStatus(304);
            return;
        }
        this.render(req, resp, urlstatus);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.render(req, resp, this.getUrlStatus(req));
    }

    private UrlValidationStatus getUrlStatus(HttpServletRequest req) {
        return this.urlGenerator.validateIframeUrl(req.getRequestURL().append('?').append(req.getQueryString()).toString());
    }
}

